/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.pti.adapter;

import com.silabs.pti.adapter.IConnection;
import com.silabs.pti.adapter.IConnectionEnabler;
import com.silabs.pti.adapter.IConnectionListener;
import com.silabs.pti.adapter.IFramer;
import com.silabs.pti.splitter.ISplitter;
import com.silabs.pti.util.ICharacterListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ConnectionSplit {
    private final ISplitter splitter;
    private final SplitConnection[] connections;
    private final IConnection connection;

    public ConnectionSplit(IConnection connection, ISplitter splitter) {
        if (splitter == null) {
            throw new IllegalArgumentException("Null not allowed");
        }
        this.splitter = splitter;
        this.connection = connection;
        this.connections = new SplitConnection[splitter.bucketCount()];
        for (int i = 0; i < splitter.bucketCount(); ++i) {
            this.connections[i] = new SplitConnection();
            splitter.setCharacterListener(i, this.connections[i]);
        }
        connection.addCharacterListener(splitter);
    }

    public void flush() {
        this.splitter.flush();
    }

    public IConnection connection(int n) {
        if (n < 0 || n >= this.connections.length) {
            throw new IllegalArgumentException("Connection count out of bounds: " + n);
        }
        return this.connections[n];
    }

    private class SplitConnection
    implements IConnection,
    ICharacterListener {
        private final List<ICharacterListener> charListeners = new ArrayList<ICharacterListener>();

        private SplitConnection() {
        }

        @Override
        public void received(byte[] ch, int offset, int len) {
            for (ICharacterListener l : this.charListeners) {
                l.received(ch, offset, len);
            }
        }

        @Override
        public void addCharacterListener(ICharacterListener listener) {
            if (!this.charListeners.contains(listener)) {
                this.charListeners.add(listener);
            }
        }

        @Override
        public void addConnectionListener(IConnectionListener listener) {
            ConnectionSplit.this.connection.addConnectionListener(listener);
        }

        @Override
        public void setConnectionEnabler(IConnectionEnabler enabler) {
            ConnectionSplit.this.connection.setConnectionEnabler(enabler);
        }

        @Override
        public void close() {
            ConnectionSplit.this.connection.close();
        }

        @Override
        public void connect() throws IOException {
            ConnectionSplit.this.connection.connect();
        }

        @Override
        public void repair() throws IOException {
        }

        @Override
        public IFramer incomingFramer() {
            return ConnectionSplit.this.connection.incomingFramer();
        }

        @Override
        public boolean isConnected() {
            return ConnectionSplit.this.connection.isConnected();
        }

        @Override
        public void removeCharacterListener(ICharacterListener listener) {
            this.charListeners.remove(listener);
        }

        @Override
        public void removeConnectionListener(IConnectionListener listener) {
            ConnectionSplit.this.connection.removeConnectionListener(listener);
        }

        @Override
        public void send(byte[] message) throws IOException {
            ConnectionSplit.this.connection.send(message);
        }

        @Override
        public void send(String message) throws IOException {
            ConnectionSplit.this.connection.send(message);
        }

        @Override
        public void setFramers(IFramer incomingFramer, IFramer outgoingFramer) {
            ConnectionSplit.this.connection.setFramers(incomingFramer, outgoingFramer);
        }

        @Override
        public void setOutgoingFramingEnabled(boolean on) {
            ConnectionSplit.this.connection.setOutgoingFramingEnabled(on);
        }

        @Override
        public IFramer outgoingFramer() {
            return ConnectionSplit.this.connection.outgoingFramer();
        }
    }
}

