/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.pti.adapter;

import com.silabs.pti.adapter.ExpectListener;
import com.silabs.pti.adapter.ExpectResponse;
import com.silabs.pti.adapter.IConnection;
import java.io.IOException;
import java.util.regex.Pattern;

public class ExpectConnection {
    private static final boolean LOG = false;
    private static int DEFAULT_TIMEOUT = 2000;
    private IConnection connection = null;
    private StringBuffer collectedOutput = null;
    private String currentOutput = null;
    private final Object expectMonitor = new Object();
    private Pattern pattern = null;
    private boolean complete = false;

    public ExpectConnection(IConnection connection) {
        this.connection = connection;
    }

    public String expect(String message, String regex) {
        return this.expect(message, regex, DEFAULT_TIMEOUT, false);
    }

    public String expect(String message, String regex, int timeout, boolean collect) {
        ExpectResponse r = this.expect(message, regex, timeout);
        if (r.succeeded()) {
            if (collect) {
                return r.collectedOutput();
            }
            return r.matchedOutput();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ExpectResponse expect(String message, String regex, int timeout) {
        if (!this.connection.isConnected()) {
            return new ExpectResponse(false, "No connection.", null, null);
        }
        ExpectListener listener = new ExpectListener(this);
        long startTime = System.currentTimeMillis();
        int waitTime = timeout - (int)(System.currentTimeMillis() - startTime);
        this.pattern = regex != null ? Pattern.compile("(?sm).*^(" + regex + ")$.*") : null;
        this.collectedOutput = new StringBuffer();
        this.currentOutput = null;
        this.complete = false;
        this.connection.addConnectionListener(listener);
        try {
            Object object = this.expectMonitor;
            synchronized (object) {
                this.connection.send(message);
                this.expectMonitor.wait(waitTime);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (IOException iOException) {
        }
        finally {
            this.connection.removeConnectionListener(listener);
        }
        ExpectResponse response = this.pattern == null || this.pattern.matcher(this.collectedOutput.toString()).matches() ? new ExpectResponse(true, null, this.currentOutput, this.collectedOutput.toString()) : new ExpectResponse(false, "No match.", null, this.collectedOutput.toString());
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receive(byte[] messageBytes) {
        if (!this.complete) {
            String message = this.connection.incomingFramer() != null ? this.connection.incomingFramer().toString(messageBytes) : new String(messageBytes);
            this.currentOutput = new String(message);
            this.collectedOutput.append(message).append("\r\n");
            if (this.pattern != null && this.pattern.matcher(this.collectedOutput.toString()).matches()) {
                this.complete = true;
                Object object = this.expectMonitor;
                synchronized (object) {
                    this.expectMonitor.notify();
                }
            }
        }
    }
}

