/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.pti.adapter;

import com.silabs.pti.adapter.ExpectConnection;
import com.silabs.pti.adapter.IConnection;
import java.io.IOException;

public class TimeSync {
    public static boolean synchronizeTime(IConnection admin, boolean isConnected, String adapterName, String successRegex, boolean canTimeSync, boolean timeServerPresent, String timeServerIp) throws IOException {
        boolean isClient = false;
        if (!isConnected) {
            throw new IOException("Failed to connect to debug port.");
        }
        if (canTimeSync) {
            if (!timeServerPresent) {
                boolean success = TimeSync.timeServer(admin, successRegex, 2000);
                if (!success) {
                    throw new IOException("Failed to set  " + adapterName + " to be time server.");
                }
            } else {
                if (timeServerIp == null || !TimeSync.timeClient(admin, timeServerIp, 2000)) {
                    throw new IOException("Failed to set " + adapterName + " to use time server at " + timeServerIp);
                }
                isClient = true;
            }
        }
        return isClient;
    }

    private static boolean timeServer(IConnection admin, String successRegex, int timeout) {
        ExpectConnection ec = new ExpectConnection(admin);
        String msg = ec.expect("time server", successRegex, timeout, false);
        return msg != null;
    }

    private static boolean timeClient(IConnection admin, String serverIP, int timeout) {
        ExpectConnection ec = new ExpectConnection(admin);
        String msg = ec.expect("time client " + serverIP, ".*" + serverIP + ".*", timeout, false);
        return msg != null;
    }
}

