/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.pti.debugchannel;

import com.silabs.pti.OutputMap;
import com.silabs.pti.adapter.IConnectionListener;
import com.silabs.pti.adapter.TimeSynchronizer;
import com.silabs.pti.debugchannel.DebugMessage;
import com.silabs.pti.debugchannel.DebugMessageType;
import com.silabs.pti.debugchannel.EventType;
import com.silabs.pti.filter.IDebugMessageFilter;
import com.silabs.pti.format.IDebugChannelExportFormat;
import com.silabs.pti.format.IDebugChannelExportOutput;
import com.silabs.pti.log.PtiLog;
import java.io.IOException;
import java.util.HashSet;

public class DebugMessageConnectionListener<T>
implements IConnectionListener {
    private final IDebugChannelExportFormat<T> ptiFormat;
    private final String originator;
    private volatile int nReceived = 0;
    private final OutputMap<T> output;
    private long t0 = -1L;
    private final TimeSynchronizer timeSync;
    private IDebugMessageFilter filter = null;
    private static HashSet<IDebugChannelExportOutput<?>> writtenHeader = new HashSet();

    public DebugMessageConnectionListener(IDebugChannelExportFormat<T> format, String originator, OutputMap<T> output, TimeSynchronizer timeSynchronizer) {
        this.ptiFormat = format;
        this.originator = originator;
        this.output = output;
        this.timeSync = timeSynchronizer;
        for (IDebugChannelExportOutput<T> v : output.values()) {
            if (writtenHeader.contains(v)) continue;
            try {
                format.writeHeader(v.writer());
            }
            catch (IOException ioe) {
                PtiLog.error("Could not write header.", ioe);
            }
            writtenHeader.add(v);
        }
    }

    @Override
    public int count() {
        return this.nReceived;
    }

    @Override
    public void messageReceived(byte[] message, long pcTime) {
        long t;
        IDebugChannelExportOutput<T> outputStream = this.output.output(this.originator);
        if (this.t0 == -1L) {
            this.t0 = System.currentTimeMillis();
            t = 0L;
        } else {
            t = System.currentTimeMillis() - this.t0;
        }
        try {
            if (DebugMessageConnectionListener.processDebugMsg(outputStream, t, this.originator, message, this.timeSync, this.ptiFormat, this.filter)) {
                ++this.nReceived;
            }
        }
        catch (IOException ioe) {
            PtiLog.error("Can't write output file", ioe);
        }
    }

    @Override
    public void connectionStateChanged(boolean isConnected) {
    }

    public void setFilter(IDebugMessageFilter debugMessageFilter) {
        this.filter = debugMessageFilter;
    }

    private static void timeCorrection(TimeSynchronizer timeSync, DebugMessage message) {
        long actualTime = timeSync.synchronizedTime(message.originatorId(), message.networkTime());
        message.setNetworkTime(actualTime);
    }

    private static <T> boolean processDebugMsg(IDebugChannelExportOutput<T> outputStream, long timeMs, String originator, byte[] bytes, TimeSynchronizer timeSync, IDebugChannelExportFormat<T> format, IDebugMessageFilter filter) throws IOException {
        if (format.isUsingRawBytes()) {
            DebugMessage dm;
            if (filter != null && !filter.isMessageKept(dm = DebugMessage.make("", bytes, timeMs))) {
                return false;
            }
            return format.formatRawBytes(outputStream.writer(), timeMs, bytes, 0, bytes.length);
        }
        DebugMessage dm = DebugMessage.make("", bytes, timeMs);
        if (filter != null && !filter.isMessageKept(dm)) {
            return false;
        }
        DebugMessageType dmt = DebugMessageType.get(dm.debugType());
        EventType type = EventType.fromDebugMessage(dmt);
        DebugMessageConnectionListener.timeCorrection(timeSync, dm);
        return format.formatDebugMessage(outputStream.writer(), originator, dm, type);
    }
}

