/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.pti.debugchannel;

public enum RadioConfiguration {
    FIFTEENFOUR(32, 8, 250, "IEEE 802.15.4"),
    BLE1(8, 32, 1000, "Bluetooth Low Energy 1"),
    BLE2(8, 32, 1000, "Bluetooth Low Energy 2");

    private final int preambleBits;
    private final int syncWordBits;
    private final int dataRateInKiloBitsPerSecond;
    private final String description;

    private RadioConfiguration(int preambleBits, int syncWordBits, int dataRateInKiloBitsPerSecond, String description) {
        this.preambleBits = preambleBits;
        this.syncWordBits = syncWordBits;
        this.dataRateInKiloBitsPerSecond = dataRateInKiloBitsPerSecond;
        this.description = description;
    }

    public String description() {
        return this.description;
    }

    private int preambleBits() {
        return this.preambleBits;
    }

    private int syncWordBits() {
        return this.syncWordBits;
    }

    private int dataRateInKiloBitsPerSecond() {
        return this.dataRateInKiloBitsPerSecond;
    }

    public int microsecondDuration(int lengthInBytes) {
        return 1000 * (lengthInBytes * 8 + this.syncWordBits() + this.preambleBits()) / this.dataRateInKiloBitsPerSecond();
    }

    public int syncAndPreableDuration() {
        return this.microsecondDuration(0);
    }

    public int microsecondDurationWithNoSyncAndPreamble(int lengthInBytes) {
        return 1000 * (lengthInBytes * 8) / this.dataRateInKiloBitsPerSecond();
    }

    public static RadioConfiguration valueFromPreference(String preferenceValue) {
        for (RadioConfiguration rc : RadioConfiguration.values()) {
            if (!rc.name().equals(preferenceValue)) continue;
            return rc;
        }
        return FIFTEENFOUR;
    }
}

