/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.pti.discovery;

import com.silabs.pti.discovery.DiscoveryKey;
import com.silabs.pti.discovery.DiscoveryProtocol;
import com.silabs.pti.discovery.IDiscoveryListener;
import com.silabs.pti.util.MiscUtil;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DiscoveryUtil {
    private static byte[] broadcast = new byte[]{-1, -1, -1, -1};

    private DiscoveryUtil() {
    }

    public static int runDiscovery(IDiscoveryListener listener) {
        try {
            DiscoveryUtil.discover(500, listener);
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }

    private static void discoverIndividualAddress(InetAddress localAddress, int durationMs, IDiscoveryListener listener) {
        String log = localAddress.getHostName();
        try {
            DatagramSocket socket = new DatagramSocket(0, localAddress);
            try {
                socket.setSoTimeout(durationMs / 10);
                DatagramPacket dp = new DatagramPacket(DiscoveryProtocol.DISCOVERY_MESSAGE, DiscoveryProtocol.DISCOVERY_MESSAGE.length);
                dp.setAddress(InetAddress.getByAddress(broadcast));
                dp.setPort(4920);
                try {
                    socket.send(dp);
                }
                catch (Exception e) {
                    System.err.println(log + ": failed to send discovery packet.");
                    socket.close();
                    return;
                }
                byte[] inBuff = new byte[500];
                DatagramPacket incoming = new DatagramPacket(inBuff, inBuff.length);
                incoming.setPort(4920);
                long lastDiscoverTime = System.currentTimeMillis();
                do {
                    try {
                        socket.receive(incoming);
                        lastDiscoverTime = System.currentTimeMillis();
                        listener.discovered(incoming);
                    }
                    catch (SocketTimeoutException socketTimeoutException) {
                        // empty catch block
                    }
                } while (System.currentTimeMillis() - lastDiscoverTime < (long)durationMs);
            }
            finally {
                try {
                    socket.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
        catch (Exception e) {
            System.err.println(log + ": discovery failed.");
            e.printStackTrace();
        }
    }

    public static Map<DiscoveryKey, String> parseDiscoveryMap(DatagramPacket packet) {
        return DiscoveryUtil.parseDiscoveryMap(new String(packet.getData()));
    }

    public static Map<DiscoveryKey, String> parseDiscoveryMap(String info) {
        String[] tokens;
        LinkedHashMap<DiscoveryKey, String> map = new LinkedHashMap<DiscoveryKey, String>();
        block2: for (String token : tokens = info.split("\\n")) {
            String[] subToks = (token = token.trim()).split("=");
            if (subToks.length != 2 || subToks[1].equals("NotSet")) continue;
            if (subToks[0].equals(DiscoveryKey.CONNECTION_TIME.key())) {
                String[] timeToken = subToks[1].split(":");
                try {
                    int day = Integer.parseInt(timeToken[0]);
                    int hour = Integer.parseInt(timeToken[1]);
                    int minute = Integer.parseInt(timeToken[2]);
                    int second = Integer.parseInt(timeToken[3]);
                    long timePassed = (((day * 24 + hour) * 60 + minute) * 60 + second) * 1000;
                    Date connectTime = new Date(new Date().getTime() - timePassed);
                    map.put(DiscoveryKey.CONNECTION_TIME, connectTime.toString());
                }
                catch (Exception exception) {}
                continue;
            }
            for (DiscoveryKey t : DiscoveryKey.values()) {
                if (!t.key().equals(subToks[0])) continue;
                map.put(t, subToks[1]);
                continue block2;
            }
        }
        return map;
    }

    private static void discover(int durationMs, IDiscoveryListener listener) throws Exception {
        ArrayList<Thread> threads = new ArrayList<Thread>();
        List<InetAddress> allLocalAddresses = MiscUtil.getIpAddresses();
        for (InetAddress localAddress : allLocalAddresses) {
            Runnable r = () -> DiscoveryUtil.discoverIndividualAddress(localAddress, durationMs, listener);
            threads.add(new Thread(r));
        }
        for (Thread t : threads) {
            t.start();
        }
        for (Thread t : threads) {
            t.join();
        }
    }
}

