/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.pti.filter;

import com.silabs.pti.debugchannel.DebugMessage;
import com.silabs.pti.filter.FilterExpression;
import com.silabs.pti.filter.IDebugMessageFilter;
import java.text.ParseException;

class DebugMessageFilterExpression
implements IDebugMessageFilter {
    public static final int FIRST = 0;
    public static final int AND = 1;
    public static final int OR = 2;
    private final int operator;
    private DebugMessageFilterExpression next = null;
    private final boolean negated;
    private IDebugMessageFilter expressionFilter;

    public DebugMessageFilterExpression(int op, String expression) throws ParseException {
        this.operator = op;
        String exp = expression.strip();
        if (exp.startsWith("!")) {
            this.negated = true;
            this.parseExpression(exp.substring(1).strip());
        } else {
            this.negated = false;
            this.parseExpression(exp);
        }
    }

    private void parseExpression(String expression) throws ParseException {
        FilterExpression fexp = null;
        if ("true".equals(expression)) {
            this.expressionFilter = IDebugMessageFilter.ALL_PASS_FILTER;
        } else if ("false".equals(expression)) {
            this.expressionFilter = IDebugMessageFilter.NO_PASS_FILTER;
        } else {
            fexp = FilterExpression.locate(expression);
            if (fexp != null) {
                this.expressionFilter = fexp.createExpression(expression);
            } else {
                throw new ParseException("Invalid filter expression: " + expression, 0);
            }
        }
    }

    @Override
    public boolean isMessageKept(DebugMessage message) {
        boolean evaluatedExpression = this.expressionFilter.isMessageKept(message);
        if (this.negated) {
            boolean bl = evaluatedExpression = !evaluatedExpression;
        }
        if (this.next != null) {
            if (this.next.operator() == 1) {
                evaluatedExpression = evaluatedExpression && this.next.isMessageKept(message);
            } else if (this.next.operator() == 2) {
                evaluatedExpression = evaluatedExpression || this.next.isMessageKept(message);
            }
        }
        return evaluatedExpression;
    }

    public int operator() {
        return this.operator;
    }

    public void and(String expression) throws ParseException {
        DebugMessageFilterExpression dmf = new DebugMessageFilterExpression(1, expression);
        if (this.next == null) {
            this.next = dmf;
        } else {
            DebugMessageFilterExpression finger = this.next;
            while (finger.next != null) {
                finger = finger.next;
            }
            finger.next = dmf;
        }
    }

    public void or(String expression) throws ParseException {
        DebugMessageFilterExpression dmf = new DebugMessageFilterExpression(2, expression);
        if (this.next == null) {
            this.next = dmf;
        } else {
            DebugMessageFilterExpression finger = this.next;
            while (finger.next != null) {
                finger = finger.next;
            }
            finger.next = dmf;
        }
    }
}

