/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.pti.filter;

import com.silabs.pti.filter.ContainsFilter;
import com.silabs.pti.filter.IDebugMessageFilter;
import com.silabs.pti.filter.OriginatorInFilter;
import com.silabs.pti.filter.TypeInFilter;
import com.silabs.pti.filter.WithinFilter;
import java.text.ParseException;

enum FilterExpression {
    TYPE_IN("typeIn"),
    ORIGINATOR_IN("originatorIn"),
    CONTAINS("contains"),
    SIZE_WITHIN("sizeWithin"),
    TIME_WITHIN("timeWithin");

    private String fnName;

    private FilterExpression(String name) {
        this.fnName = name;
    }

    public static FilterExpression locate(String expression) {
        for (FilterExpression fe : FilterExpression.values()) {
            if (!expression.startsWith(fe.functionName() + "(") || !expression.endsWith(")")) continue;
            return fe;
        }
        return null;
    }

    public IDebugMessageFilter createExpression(String expression) throws ParseException {
        String parenthesesContent = expression.substring(this.fnName.length() + 1, expression.length() - 1);
        IDebugMessageFilter dms = IDebugMessageFilter.NO_PASS_FILTER;
        switch (this) {
            case TYPE_IN: {
                dms = new TypeInFilter(parenthesesContent);
                break;
            }
            case CONTAINS: {
                dms = new ContainsFilter(parenthesesContent);
                break;
            }
            case ORIGINATOR_IN: {
                dms = new OriginatorInFilter(parenthesesContent);
                break;
            }
            case SIZE_WITHIN: {
                dms = new WithinFilter(0, parenthesesContent);
                break;
            }
            case TIME_WITHIN: {
                dms = new WithinFilter(1, parenthesesContent);
            }
        }
        return dms;
    }

    public String functionName() {
        return this.fnName;
    }
}

