/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.pti.log;

import com.silabs.pti.log.DefaultLogger;
import com.silabs.pti.log.IPtiLogger;
import com.silabs.pti.log.PtiSeverity;

public class PtiLog {
    private static IPtiLogger logger = new DefaultLogger();

    private PtiLog() {
    }

    public static void setLogger(IPtiLogger loggerInstance) {
        logger = loggerInstance;
    }

    public static void info(String message) {
        PtiLog.info(message, null);
    }

    public static void info(String message, Throwable throwable) {
        logger.log(PtiSeverity.INFO, message, throwable);
    }

    public static void error(String message) {
        PtiLog.error(message, null);
    }

    public static void error(Throwable throwable) {
        PtiLog.error(null, throwable);
    }

    public static void error(String message, Throwable throwable) {
        logger.log(PtiSeverity.ERROR, message, throwable);
    }

    public static void warning(String message) {
        PtiLog.warning(message, null);
    }

    public static void warning(String message, Throwable throwable) {
        logger.log(PtiSeverity.WARNING, message, throwable);
    }

    public static void message(PtiSeverity severity, String message, Throwable t) {
        switch (severity) {
            case ERROR: 
            case INFO: 
            case WARNING: {
                logger.log(severity, message, t);
                break;
            }
        }
    }
}

