/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.api.toolchain.core;

import com.silabs.java.utils.ITypedFilter;
import com.silabs.java.utils.extension.ExcludeTestPluginsFilter;
import com.silabs.java.utils.extension.IExtensionInformation;
import com.silabs.java.utils.extension.OnlyTestPluginsFilter;
import com.silabs.ss.framework.project.api.toolchain.core.IToolchain;
import com.silabs.ss.framework.project.api.toolchain.core.IToolchainDescriptor;
import com.silabs.ss.framework.project.api.toolchain.core.IToolchainManager;
import com.silabs.ss.framework.project.api.toolchain.core.ToolchainProperties;
import com.silabs.ss.framework.project.internal.api.toolchain.core.ToolchainRegistry;
import com.silabs.ss.framework.project.internal.toolchain.core.ToolchainDescriptor;
import com.silabs.ss.platform.api.descriptor.core.IDescriptor;
import com.silabs.ss.platform.api.descriptor.core.compatibility.Compatibility;
import com.silabs.ss.platform.api.descriptor.core.compatibility.ICompatibilityQuery;
import com.silabs.ss.platform.api.descriptor.core.manager.BaseVersionedManager;
import com.silabs.ss.platform.api.descriptor.core.manager.ManagerConfigFactory;
import com.silabs.ss.platform.api.descriptor.core.model.MDescriptor;
import com.silabs.ss.platform.api.descriptor.core.registry.IRegistry;

public class ToolchainManager
extends BaseVersionedManager<IToolchainDescriptor, IToolchain>
implements IToolchainManager {
    public static final String TOOLCHAIN_PROVIDER_ELEMENT = "toolchainProvider";
    public static final String TOOLCHAIN_DETECTOR_ELEMENT = "toolchainDetector";

    public static ToolchainManager create() {
        ToolchainManager tcMgr = new ToolchainManager(false, (ITypedFilter<IExtensionInformation>)new ExcludeTestPluginsFilter());
        return tcMgr;
    }

    public static ToolchainManager createForTesting() {
        ToolchainManager tcMgr = new ToolchainManager(true, (ITypedFilter<IExtensionInformation>)new OnlyTestPluginsFilter());
        tcMgr.reset();
        tcMgr.getExtensionManager().startup();
        return tcMgr;
    }

    public static ToolchainManager createWithFilterForTesting(ITypedFilter<IExtensionInformation> filter) {
        ToolchainManager tcMgr = new ToolchainManager(true, filter);
        tcMgr.reset();
        tcMgr.getExtensionManager().startup();
        return tcMgr;
    }

    protected ToolchainManager(boolean testMode, ITypedFilter<IExtensionInformation> filter) {
        super(ManagerConfigFactory.forRegistryAndEntity(ToolchainRegistry.createFactory(), IToolchain.class).isTestMode(testMode).withSyncLabel("Scanning toolchains...").withConfigurationElementFilter(filter).withRegistry(ToolchainRegistry.class).withProviderExtensionElement(TOOLCHAIN_PROVIDER_ELEMENT).createExtensionBackedManagerConfig());
    }

    public IToolchainDescriptor createDescriptor() {
        return new ToolchainDescriptor();
    }

    public IToolchainDescriptor createDescriptor(MDescriptor desc) {
        return new ToolchainDescriptor(desc);
    }

    @Override
    public boolean isCompatibleWithToolchain(IToolchainDescriptor desc, String otherToolchainId) {
        return Compatibility.fromProperty((IDescriptor)desc, ToolchainProperties.TOOLCHAIN_COMPATIBILITY).isCompatibleWith(otherToolchainId);
    }

    @Override
    public IToolchainDescriptor[] getCompatibleToolchainDescriptors(IToolchainDescriptor desc) {
        ICompatibilityQuery query = Compatibility.fromProperty((IDescriptor)desc, ToolchainProperties.TOOLCHAIN_COMPATIBILITY, (IRegistry)this);
        return (IToolchainDescriptor[])query.getCompatibleDescriptors((IRegistry)this);
    }
}

