/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.api.toolchain.core;

import com.silabs.java.utils.runtime.RuntimeUtils;
import com.silabs.ss.framework.project.api.toolchain.core.IToolchainDescriptor;
import com.silabs.ss.framework.project.internal.api.toolchain.core.ToolchainManagerCompatibilityAdapter;
import com.silabs.ss.framework.project.internal.toolchain.core.Activator;
import com.silabs.ss.framework.project.internal.toolchain.core.ToolchainDescriptor;
import com.silabs.ss.platform.api.descriptor.core.IDescriptor;
import com.silabs.ss.platform.api.descriptor.core.compatibility.IDescriptorCompatibilityAdapter;
import com.silabs.ss.platform.api.descriptor.core.property.CoreProperties;
import com.silabs.ss.platform.api.descriptor.core.registry.BaseExtensionBackedRegistry;
import com.silabs.ss.platform.api.descriptor.core.registry.IExtensionBackedRegistryConfig;
import com.silabs.ss.platform.api.descriptor.core.registry.RegistryConfigFactory;
import com.silabs.ss.platform.api.descriptor.core.registry.plugins.IRegistryPluginProvider;
import com.silabs.ss.platform.api.descriptor.core.registry.plugins.RegistryCacheProvider;
import com.silabs.ss.platform.api.descriptor.core.registry.plugins.RegistryTransientDescriptorProvider;
import java.io.File;
import java.net.URI;

public class ToolchainRegistry
extends BaseExtensionBackedRegistry<IToolchainDescriptor> {
    protected static final String PREF_SCOPE = "toolchainManager/";
    protected static final String TOOLCHAIN_SUPPORT_EXTENSION_NAME = "toolchainSupport";
    private static final String TOOLCHAIN_DESCRIPTOR_ELEMENT = "toolchainDescriptor";
    private static final String TOOLCHAIN_CONTENT_ID = "toolchain";

    public ToolchainRegistry(IExtensionBackedRegistryConfig<IToolchainDescriptor> config) {
        super(config);
    }

    static RegistryConfigFactory<IToolchainDescriptor> createFactory() {
        return RegistryConfigFactory.forDescriptor(IToolchainDescriptor.class, ToolchainDescriptor.class).forBundle(Activator.id()).withRegistryPluginProvider((IRegistryPluginProvider)new RegistryTransientDescriptorProvider()).withPackageTypes(new String[]{TOOLCHAIN_CONTENT_ID}).withPreferenceScope(PREF_SCOPE).withNoneDescriptorId("com.silabs.ss.framework.project.core.noToolChain:0.0.0").withDetector("toolchainDetector", "Scanning toolchains...").withDistinctInstallPaths(true).withExtensionName(TOOLCHAIN_SUPPORT_EXTENSION_NAME).withExtensionDescriptorElement(TOOLCHAIN_DESCRIPTOR_ELEMENT, TOOLCHAIN_CONTENT_ID);
    }

    protected static RegistryCacheProvider.CacheValidator<IToolchainDescriptor> getValidator() {
        return descr -> {
            URI instPath = (URI)descr.getProperty(CoreProperties.INSTALLATION_PATH);
            if (instPath == null) {
                return RuntimeUtils.isJUnitRunning();
            }
            File loc = new File(instPath);
            return loc.exists();
        };
    }

    public boolean registerDescriptor(IToolchainDescriptor desc) {
        if (desc.getLabel().equals("Debug") || desc.getLabel().equals("Release")) assert (false);
        return super.registerDescriptor((IDescriptor)desc);
    }

    protected IDescriptorCompatibilityAdapter<IToolchainDescriptor> createDescriptorCompatibilityAdapter() {
        return new ToolchainManagerCompatibilityAdapter();
    }
}

