/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.api.toolchain.core.configs;

import com.silabs.java.utils.TextUtils;
import com.silabs.java.utils.preferences.PropertyReference;
import com.silabs.ss.framework.project.api.toolchain.core.IToolOption;
import com.silabs.ss.framework.project.api.toolchain.core.IToolchainDescriptor;
import com.silabs.ss.framework.project.api.toolchain.core.configs.IStockConfigurationDescriptor;
import com.silabs.ss.framework.project.api.toolchain.core.configs.IStockConfigurationManager;
import com.silabs.ss.framework.project.api.toolchain.core.configs.StockConfigurationProperties;
import com.silabs.ss.framework.project.internal.toolchain.core.Activator;
import com.silabs.ss.platform.api.descriptor.core.BaseDescriptor;
import com.silabs.ss.platform.api.descriptor.core.model.MDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BaseStockConfigurationDescriptor
extends BaseDescriptor
implements IStockConfigurationDescriptor {
    private IToolchainDescriptor toolchainDesc;
    private List<IToolOption> stockOptions;
    private String baseId;

    public BaseStockConfigurationDescriptor() {
    }

    public BaseStockConfigurationDescriptor(MDescriptor desc) {
        super(desc);
    }

    public BaseStockConfigurationDescriptor(IToolchainDescriptor toolchainDesc) {
        this.toolchainDesc = toolchainDesc;
    }

    public BaseStockConfigurationDescriptor(IToolchainDescriptor toolchainDesc, MDescriptor desc) {
        super(desc);
        this.toolchainDesc = toolchainDesc;
    }

    public String getId() {
        return super.getId() + (String)(this.toolchainDesc != null ? "#" + this.toolchainDesc.getId() : "");
    }

    protected String getDefaultPropertyScope() {
        return "stockConfig";
    }

    public IToolchainDescriptor getParent() {
        return this.toolchainDesc;
    }

    @Override
    public void setParent(IToolchainDescriptor tc) {
        this.toolchainDesc = tc;
    }

    @Override
    public String getBaseTemplateId() {
        return this.baseId;
    }

    @Override
    public void setBaseTemplateId(String baseId) {
        this.baseId = baseId;
        this.stockOptions = null;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.toolchainDesc == null ? 0 : this.toolchainDesc.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseStockConfigurationDescriptor other = (BaseStockConfigurationDescriptor)obj;
        return !(this.toolchainDesc == null ? other.toolchainDesc != null : !this.toolchainDesc.equals(other.toolchainDesc));
    }

    @Override
    public synchronized List<IToolOption> getStockOptions(IStockConfigurationManager manager) {
        if (this.stockOptions == null) {
            ArrayList<IToolOption> stockOptions = new ArrayList<IToolOption>();
            if (!TextUtils.isEmpty((String)this.baseId)) {
                IStockConfigurationDescriptor base;
                IStockConfigurationDescriptor iStockConfigurationDescriptor = base = manager != null ? (IStockConfigurationDescriptor)manager.getTemplateRegistry().findDescriptor(this.baseId) : null;
                if (base == null) {
                    Activator.reporter.logError("unknown base stock configuration id: " + this.baseId, null);
                } else {
                    List<IToolOption> allStockOptions = null;
                    allStockOptions = base.getStockOptions(manager);
                    stockOptions.addAll(allStockOptions);
                }
            }
            Collection myStockOptions = (Collection)this.getProperty(StockConfigurationProperties.STOCK_OPTIONS);
            stockOptions.addAll(myStockOptions);
            this.stockOptions = stockOptions;
        }
        return this.stockOptions;
    }

    public <T> Collection<T> gatherListProperty(PropertyReference<Collection<T>> key) {
        return (Collection)this.getProperty(key);
    }
}

