/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.api.toolchain.core.configs;

import com.silabs.java.utils.ArrayUtils;
import com.silabs.java.utils.ITypedFilter;
import com.silabs.java.utils.TextUtils;
import com.silabs.java.utils.extension.ExcludeTestPluginsFilter;
import com.silabs.java.utils.extension.IExtensionInformation;
import com.silabs.java.utils.extension.OnlyTestPluginsFilter;
import com.silabs.java.utils.preferences.IPreferences;
import com.silabs.ss.framework.project.api.toolchain.core.IToolchain;
import com.silabs.ss.framework.project.api.toolchain.core.IToolchainDescriptor;
import com.silabs.ss.framework.project.api.toolchain.core.IToolchainManager;
import com.silabs.ss.framework.project.api.toolchain.core.Toolchain;
import com.silabs.ss.framework.project.api.toolchain.core.ToolchainProperties;
import com.silabs.ss.framework.project.api.toolchain.core.configs.IStockConfiguration;
import com.silabs.ss.framework.project.api.toolchain.core.configs.IStockConfigurationDescriptor;
import com.silabs.ss.framework.project.api.toolchain.core.configs.IStockConfigurationManager;
import com.silabs.ss.framework.project.api.toolchain.core.configs.IStockConfigurationTemplateRegistry;
import com.silabs.ss.framework.project.api.toolchain.core.configs.StockConfigurationProperties;
import com.silabs.ss.framework.project.internal.api.toolchain.core.configs.StockConfigurationRegistry;
import com.silabs.ss.framework.project.internal.api.toolchain.core.configs.StockConfigurationTemplateRegistry;
import com.silabs.ss.framework.project.internal.toolchain.core.configs.StockConfigurationProvider;
import com.silabs.ss.platform.api.descriptor.core.IDescriptor;
import com.silabs.ss.platform.api.descriptor.core.compatibility.Compatibility;
import com.silabs.ss.platform.api.descriptor.core.compatibility.ICompatibilityQuery;
import com.silabs.ss.platform.api.descriptor.core.manager.BaseManager;
import com.silabs.ss.platform.api.descriptor.core.manager.IEntityProvider;
import com.silabs.ss.platform.api.descriptor.core.manager.ManagerConfigFactory;
import com.silabs.ss.platform.api.descriptor.core.model.MDescriptor;
import com.silabs.ss.platform.api.descriptor.core.property.CoreProperties;
import com.silabs.ss.platform.api.descriptor.core.registry.IDetector;
import com.silabs.ss.platform.api.descriptor.core.registry.IRegistry;
import com.silabs.ss.platform.api.descriptor.core.registry.IRegistryListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class StockConfigurationManager
extends BaseManager<IStockConfigurationDescriptor, IStockConfiguration>
implements IStockConfigurationManager {
    private static final String DEFAULT_INITIAL_CONFIG_IDS = "defaultInitialConfigs";
    private ICompatibilityQuery<IStockConfigurationDescriptor> debugCompatibility;
    private StockConfigurationTemplateRegistry templateRegistry;
    private IToolchainManager tcMgr;
    private Map<String, String> defaultInitialConfigurations = new HashMap<String, String>();
    private IDetector<IStockConfigurationDescriptor> detector;
    private IRegistryListener<IToolchainDescriptor> tcMgrListener;
    private IRegistryListener<IStockConfigurationDescriptor> templateListener;

    public static StockConfigurationManager create() {
        StockConfigurationManager manager = new StockConfigurationManager(false, (ITypedFilter<IExtensionInformation>)new ExcludeTestPluginsFilter(), Toolchain.manager());
        return manager;
    }

    public static StockConfigurationManager createForTesting(IToolchainManager tcmgr) {
        return StockConfigurationManager.createWithFilterForTesting(tcmgr, (ITypedFilter<IExtensionInformation>)new OnlyTestPluginsFilter());
    }

    public static StockConfigurationManager createWithFilterForTesting(IToolchainManager tcmgr, ITypedFilter<IExtensionInformation> filter) {
        StockConfigurationManager manager = new StockConfigurationManager(true, filter, tcmgr);
        manager.getExtensionManager().startup();
        return manager;
    }

    protected StockConfigurationManager(boolean testMode, ITypedFilter<IExtensionInformation> filter, IToolchainManager tcMgr_) {
        super(ManagerConfigFactory.forRegistryAndEntity(StockConfigurationRegistry.createFactory(), IStockConfiguration.class).isTestMode(testMode).withSyncLabel("Initializing build targets...").isAutoEnable(true).withExtensionName("toolchainSupport").withConfigurationElementFilter(filter).withRegistry(StockConfigurationRegistry.class).withProviderExtensionElement("stockConfigurationProvider").createExtensionBackedManagerConfig());
        ((StockConfigurationRegistry)this.registry).setManager(this);
        this.tcMgr = tcMgr_;
        this.templateRegistry = new StockConfigurationTemplateRegistry(this.getExtensionManager(), testMode);
        this.templateRegistry.setManager(this);
        this.debugCompatibility = Compatibility.fromGrammarString((IRegistry)this, (String)"com.silabs.ss.framework.project.toolchain.core.debug");
        this.tcMgrListener = event -> {
            if (event.isAdded() || event.isRemoved()) {
                this.resetSync();
            }
        };
        this.templateListener = event -> {
            if (event.isAdded() || event.isRemoved()) {
                this.resetSync();
            }
        };
        this.detector = new IDetector<IStockConfigurationDescriptor>(){

            public IStockConfigurationDescriptor[] detectDescriptors(Map<String, Object> parameters, IProgressMonitor monitor) throws CoreException {
                ArrayList<IStockConfigurationDescriptor> list = new ArrayList<IStockConfigurationDescriptor>();
                if (Boolean.TRUE.equals(parameters.get("quickScanSystem")) || Boolean.FALSE.equals(parameters.get("quickScanSystem")) && StockConfigurationManager.this.config.isTestMode()) {
                    monitor.beginTask("", 1);
                    IToolchainDescriptor[] iToolchainDescriptorArray = (IToolchainDescriptor[])StockConfigurationManager.this.tcMgr.getAllDescriptors();
                    int n = iToolchainDescriptorArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IToolchainDescriptor tcDesc = iToolchainDescriptorArray[n2];
                        list.addAll(StockConfigurationManager.this.createDescriptorsFor(tcDesc));
                        ++n2;
                    }
                    monitor.worked(1);
                    monitor.done();
                }
                return list.toArray(new IStockConfigurationDescriptor[list.size()]);
            }
        };
        this.setupManager();
    }

    private void setupManager() {
        this.registerProvider("", (IEntityProvider)new StockConfigurationProvider(this.tcMgr));
        this.tcMgr.addRegistryListener(this.tcMgrListener);
        this.templateRegistry.addRegistryListener(this.templateListener);
        this.registry.registerDetector(this.detector);
    }

    public void resetRegistry() {
        super.resetRegistry();
        this.setupManager();
    }

    public void reset() {
        super.reset();
        this.setupManager();
    }

    public IStockConfigurationDescriptor createDescriptor() {
        throw new UnsupportedOperationException("may only be created with a toolchain");
    }

    public IStockConfigurationDescriptor createDescriptor(MDescriptor desc) {
        throw new UnsupportedOperationException("may only be created with a toolchain");
    }

    @Override
    public IStockConfigurationDescriptor[] getStockConfigurationDescriptors(String toolchainId) {
        ArrayList<IStockConfigurationDescriptor> stocks = new ArrayList<IStockConfigurationDescriptor>(1);
        IToolchainDescriptor tc = (IToolchainDescriptor)this.tcMgr.findDescriptor(toolchainId);
        if (tc != null) {
            IStockConfigurationDescriptor[] iStockConfigurationDescriptorArray = (IStockConfigurationDescriptor[])this.getAllDescriptors();
            int n = iStockConfigurationDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStockConfigurationDescriptor desc = iStockConfigurationDescriptorArray[n2];
                if (tc.equals(desc.getParent())) {
                    stocks.add(desc);
                }
                ++n2;
            }
        }
        return stocks.toArray(new IStockConfigurationDescriptor[stocks.size()]);
    }

    @Override
    public IStockConfigurationDescriptor[] getStockConfigurationDescriptorsFor(String toolchainId, String ... stockConfigTemplateIds) {
        ArrayList<IStockConfigurationDescriptor> stocks = new ArrayList<IStockConfigurationDescriptor>(1);
        IToolchainDescriptor tc = (IToolchainDescriptor)this.tcMgr.findDescriptor(toolchainId);
        IStockConfigurationDescriptor[] iStockConfigurationDescriptorArray = (IStockConfigurationDescriptor[])this.getAllDescriptors();
        int n = iStockConfigurationDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStockConfigurationDescriptor desc = iStockConfigurationDescriptorArray[n2];
            String stockTemplateId = (String)desc.getProperty(StockConfigurationProperties.STOCK_CONFIGURATION_TEMPLATE_ID);
            if (((IToolchainDescriptor)desc.getParent()).equals(tc)) {
                IStockConfigurationDescriptor templ = desc;
                while (templ != null) {
                    if (ArrayUtils.contains((Object[])stockConfigTemplateIds, (Object)stockTemplateId)) {
                        if (stocks.contains(desc)) break;
                        stocks.add(desc);
                        break;
                    }
                    if ((templ = (IStockConfigurationDescriptor)this.templateRegistry.findDescriptor(templ.getBaseTemplateId())) == null) break;
                    stockTemplateId = templ.getId();
                }
            }
            ++n2;
        }
        return stocks.toArray(new IStockConfigurationDescriptor[stocks.size()]);
    }

    protected IStockConfiguration realizeEntity(IStockConfigurationDescriptor desc) throws CoreException {
        IToolchain tc = (IToolchain)this.tcMgr.find((IDescriptor)((IToolchainDescriptor)desc.getParent()));
        if (tc == null) {
            return null;
        }
        return (IStockConfiguration)super.realizeEntity((IDescriptor)desc);
    }

    @Override
    public IStockConfiguration[] getStockConfigurations(String toolchainId) {
        IToolchain toolchain = (IToolchain)this.tcMgr.find(toolchainId);
        if (toolchain == null) {
            return new IStockConfiguration[0];
        }
        List<IStockConfiguration> stocks = Stream.of(this.getStockConfigurationDescriptors(toolchainId)).map(arg_0 -> ((StockConfigurationManager)this).find(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        return stocks.toArray(new IStockConfiguration[stocks.size()]);
    }

    protected Collection<IStockConfigurationDescriptor> createDescriptorsFor(IToolchainDescriptor tcDesc) {
        ArrayList<IStockConfigurationDescriptor> list = new ArrayList<IStockConfigurationDescriptor>();
        IStockConfigurationDescriptor[] iStockConfigurationDescriptorArray = (IStockConfigurationDescriptor[])this.templateRegistry.getAllDescriptors();
        int n = iStockConfigurationDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStockConfigurationDescriptor descr = iStockConfigurationDescriptorArray[n2];
            if (Compatibility.fromProperty((IDescriptor)descr, ToolchainProperties.TOOLCHAIN_COMPATIBILITY, (IRegistry)Toolchain.manager()).isCompatibleWith((IDescriptor)tcDesc)) {
                IStockConfigurationDescriptor stockConfigForToolchainDescr = (IStockConfigurationDescriptor)descr.copy();
                stockConfigForToolchainDescr.setBaseTemplateId(descr.getId());
                stockConfigForToolchainDescr.setParent(tcDesc);
                stockConfigForToolchainDescr.setProperty(CoreProperties.BUILTIN, true);
                stockConfigForToolchainDescr.setProperty(StockConfigurationProperties.STOCK_CONFIGURATION_TEMPLATE_ID, descr.getId());
                if (this.debugCompatibility.isCompatibleWith((IDescriptor)stockConfigForToolchainDescr)) {
                    stockConfigForToolchainDescr.setProperty(CoreProperties.PREFERRED, true);
                }
                list.add(stockConfigForToolchainDescr);
            }
            ++n2;
        }
        return list;
    }

    public void registerDescriptorsFor(IToolchainDescriptor tcDesc) {
        for (IStockConfigurationDescriptor stock : this.createDescriptorsFor(tcDesc)) {
            this.registerDescriptor((IDescriptor)stock);
        }
    }

    public void removeDescriptorsFor(IToolchainDescriptor tcDesc) {
        IStockConfigurationDescriptor[] iStockConfigurationDescriptorArray = (IStockConfigurationDescriptor[])this.getAllDescriptors();
        int n = iStockConfigurationDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStockConfigurationDescriptor descr = iStockConfigurationDescriptorArray[n2];
            if (((IToolchainDescriptor)descr.getParent()).equals(tcDesc)) {
                this.removeDescriptor((IDescriptor)descr);
            }
            ++n2;
        }
    }

    @Override
    public IStockConfigurationTemplateRegistry getTemplateRegistry() {
        return this.templateRegistry;
    }

    protected void saveToPrefs(IPreferences prefs, IStockConfigurationDescriptor[] descs) {
        super.saveToPrefs(prefs, (IDescriptor[])descs);
        if (!this.defaultInitialConfigurations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> ent : this.defaultInitialConfigurations.entrySet()) {
                sb.append(ent.getKey()).append('\u0000').append(ent.getValue()).append('\u0000');
            }
            prefs.put(DEFAULT_INITIAL_CONFIG_IDS, sb.toString());
        }
    }

    protected void doLoadFromPrefs(IPreferences prefs) {
        String defaultInitialConfigurationStr;
        super.doLoadFromPrefs(prefs);
        if (this.defaultInitialConfigurations == null) {
            this.defaultInitialConfigurations = new HashMap<String, String>();
        }
        if (!TextUtils.isEmpty((String)(defaultInitialConfigurationStr = prefs.get(DEFAULT_INITIAL_CONFIG_IDS, null)))) {
            String[] ents = defaultInitialConfigurationStr.split("\u0000");
            int i = 0;
            while (i < ents.length) {
                this.defaultInitialConfigurations.put(ents[i], ents[i + 1]);
                i += 2;
            }
        }
    }

    @Override
    public IStockConfigurationDescriptor getDefaultInitialConfiguration(String architectureFamily) {
        return (IStockConfigurationDescriptor)this.findDescriptor(this.defaultInitialConfigurations.get(architectureFamily));
    }

    @Override
    public void setDefaultInitialConfiguration(String architectureFamily, IStockConfigurationDescriptor descr) {
        if (descr != null) {
            this.defaultInitialConfigurations.put(architectureFamily, descr.getId());
        } else {
            this.defaultInitialConfigurations.remove(architectureFamily);
        }
        try {
            this.savePrefs();
        }
        catch (CoreException e) {
            this.getConfig().getStatusReporter().logError(null, (Throwable)e);
        }
    }
}

