/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ELanguage implements Enumerator
{
    OBJ(0, "OBJ", "obj"),
    C(1, "C", "c"),
    CPP(2, "CPP", "cpp"),
    ASM(3, "ASM", "asm");

    public static final int OBJ_VALUE = 0;
    public static final int C_VALUE = 1;
    public static final int CPP_VALUE = 2;
    public static final int ASM_VALUE = 3;
    private static final ELanguage[] VALUES_ARRAY;
    public static final List<ELanguage> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ELanguage[]{OBJ, C, CPP, ASM};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ELanguage get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ELanguage result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ELanguage getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ELanguage result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ELanguage get(int value) {
        switch (value) {
            case 0: {
                return OBJ;
            }
            case 1: {
                return C;
            }
            case 2: {
                return CPP;
            }
            case 3: {
                return ASM;
            }
        }
        return null;
    }

    private ELanguage(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

