/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.model.impl;

import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.project.api.core.model.MEntry;
import com.silabs.ss.framework.project.api.core.model.MFileReference;
import com.silabs.ss.framework.project.api.core.model.MFolderContent;
import com.silabs.ss.framework.project.api.core.model.MFolderEntry;
import com.silabs.ss.framework.project.api.core.model.MFolderReference;
import com.silabs.ss.framework.project.api.core.model.MReference;
import com.silabs.ss.framework.project.api.core.model.ProjectModelPackage;
import com.silabs.ss.framework.project.api.core.model.impl.MReferenceImpl;
import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

public class MFolderReferenceImpl
extends MReferenceImpl
implements MFolderReference {
    protected MFolderEntry ref;
    protected EList<MFileReference> files;
    protected EList<MFolderReference> folders;

    protected MFolderReferenceImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return ProjectModelPackage.Literals.MFOLDER_REFERENCE;
    }

    @Override
    public MFolderEntry getRef() {
        if (this.ref != null && this.ref.eIsProxy()) {
            InternalEObject oldRef = (InternalEObject)this.ref;
            this.ref = (MFolderEntry)this.eResolveProxy(oldRef);
            if (this.ref != oldRef && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 6, (Object)oldRef, (Object)this.ref));
            }
        }
        return this.ref;
    }

    public MFolderEntry basicGetRef() {
        return this.ref;
    }

    @Override
    public void setRef(MFolderEntry newRef) {
        MFolderEntry oldRef = this.ref;
        this.ref = newRef;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldRef, (Object)this.ref));
        }
    }

    @Override
    public EList<MFileReference> getFiles() {
        if (this.files == null) {
            this.files = new EObjectContainmentEList(MFileReference.class, (InternalEObject)this, 7);
        }
        return this.files;
    }

    @Override
    public EList<MFolderReference> getFolders() {
        if (this.folders == null) {
            this.folders = new EObjectContainmentEList(MFolderReference.class, (InternalEObject)this, 8);
        }
        return this.folders;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 7: {
                return ((InternalEList)this.getFiles()).basicRemove((Object)otherEnd, msgs);
            }
            case 8: {
                return ((InternalEList)this.getFolders()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 6: {
                if (resolve) {
                    return this.getRef();
                }
                return this.basicGetRef();
            }
            case 7: {
                return this.getFiles();
            }
            case 8: {
                return this.getFolders();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 6: {
                this.setRef((MFolderEntry)newValue);
                return;
            }
            case 7: {
                this.getFiles().clear();
                this.getFiles().addAll((Collection)newValue);
                return;
            }
            case 8: {
                this.getFolders().clear();
                this.getFolders().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 6: {
                this.setRef(null);
                return;
            }
            case 7: {
                this.getFiles().clear();
                return;
            }
            case 8: {
                this.getFolders().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 6: {
                return this.ref != null;
            }
            case 7: {
                return this.files != null && !this.files.isEmpty();
            }
            case 8: {
                return this.folders != null && !this.folders.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public boolean isExcludedTree() {
        return this.doIsExcludedTree(false);
    }

    private boolean doIsExcludedTree(boolean defaultReturnEmpty) {
        boolean isUnknown;
        if (this.isExcluded()) {
            return true;
        }
        boolean noEntries = this.getFiles().isEmpty() && this.getFolders().isEmpty();
        boolean bl = isUnknown = this.getRef() instanceof MFolderContent && (((MFolderContent)this.getRef()).isIncludeAllFolders() || ((MFolderContent)this.getRef()).isIncludeAllFiles());
        if (noEntries && !isUnknown) {
            return defaultReturnEmpty;
        }
        return this.isExcludedChildren();
    }

    @Override
    public boolean isExcludedChildren() {
        boolean any = false;
        for (MFileReference file : this.getFiles()) {
            if (!file.isExcluded()) {
                return false;
            }
            any = true;
        }
        for (MFolderReference folder : this.getFolders()) {
            if (!((MFolderReferenceImpl)folder).doIsExcludedTree(true)) {
                return false;
            }
            any = true;
        }
        return any;
    }

    @Override
    public boolean isBuiltinTree() {
        if (!this.isBuiltin()) {
            return false;
        }
        if (this.getFiles().isEmpty() && this.getFolders().isEmpty()) {
            return true;
        }
        return this.isBuiltinChildren();
    }

    @Override
    public boolean isBuiltinChildren() {
        boolean any = false;
        for (MFileReference file : this.getFiles()) {
            if (!file.isBuiltin()) {
                return false;
            }
            any = true;
        }
        for (MFolderReference folder : this.getFolders()) {
            if (!folder.isBuiltinTree()) {
                return false;
            }
            any = true;
        }
        return any;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        MFolderReferenceImpl.dumpTree(sb, 0, this);
        return sb.toString();
    }

    private static void dumpTree(StringBuilder sb, int indent, MReference ref) {
        MEntry entryRef = ref.getRef();
        String name = entryRef == null ? ref.getClass().getSimpleName() : entryRef.getName();
        sb.append(TextUtils.indent((String)name, (int)indent, (String)"  "));
        sb.append("; builtin=").append(ref.isBuiltin()).append("; excluded=").append(ref.isExcluded());
        if (ref.getProvidingModule() != null) {
            sb.append(" [module]");
        }
        sb.append('\n');
        if (ref instanceof MFolderReference) {
            MFolderReference folder = (MFolderReference)ref;
            for (MReference f : folder.getFolders()) {
                MFolderReferenceImpl.dumpTree(sb, indent + 1, f);
            }
            for (MReference f : folder.getFiles()) {
                MFolderReferenceImpl.dumpTree(sb, indent + 1, f);
            }
        }
    }
}

