/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.model.migrate;

import com.silabs.java.utils.extension.ExtensionManager;
import com.silabs.java.utils.extension.IExtensionElementHandler;
import com.silabs.java.utils.extension.IExtensionManager;
import com.silabs.java.utils.extension.IExtensionManagerHolder;
import com.silabs.ss.framework.project.api.core.model.migrate.IFeatureMigrator;
import com.silabs.ss.framework.project.internal.core.model.Activator;
import com.silabs.ss.platform.api.descriptor.core.manager.SingletonAccessor;
import java.util.ArrayList;
import java.util.List;

public final class ProjectFeatureMigrator
implements IExtensionManagerHolder {
    private IExtensionManager extensionManager;
    private List<IFeatureMigrator> partIdMigrators = new ArrayList<IFeatureMigrator>();
    private List<IFeatureMigrator> boardIdMigrators = new ArrayList<IFeatureMigrator>();
    private List<IFeatureMigrator> toolChainIdMigrators = new ArrayList<IFeatureMigrator>();
    private List<IFeatureMigrator> extensionMigrators = new ArrayList<IFeatureMigrator>();
    private List<IFeatureMigrator> sdkIdMigrators = new ArrayList<IFeatureMigrator>();

    @SingletonAccessor
    public static ProjectFeatureMigrator instance() {
        return SingletonHolder.INSTANCE;
    }

    private ProjectFeatureMigrator() {
    }

    public IExtensionManager getExtensionManager() {
        if (this.extensionManager == null) {
            this.extensionManager = new ExtensionManager(Activator.id(), "projectMigrator", null);
            this.extensionManager.addHandler("partIdMigrator", ProjectFeatureMigrator.createElementHandler(this.partIdMigrators));
            this.extensionManager.addHandler("boardIdMigrator", ProjectFeatureMigrator.createElementHandler(this.boardIdMigrators));
            this.extensionManager.addHandler("toolChainIdMigrator", ProjectFeatureMigrator.createElementHandler(this.toolChainIdMigrators));
            this.extensionManager.addHandler("extensionMigrator", ProjectFeatureMigrator.createElementHandler(this.extensionMigrators));
            this.extensionManager.addHandler("sdkIdMigrator", ProjectFeatureMigrator.createElementHandler(this.sdkIdMigrators));
        }
        return this.extensionManager;
    }

    private static IExtensionElementHandler createElementHandler(List<IFeatureMigrator> migrators) {
        return (element, added, context) -> {
            IFeatureMigrator migrator = (IFeatureMigrator)element.createExecutableExtension("class");
            if (added) {
                migrators.add(migrator);
            } else {
                migrators.remove(migrator);
            }
        };
    }

    public String migratePartId(String oldValue) {
        return ProjectFeatureMigrator.migrateFeature(oldValue, this.partIdMigrators);
    }

    public String migrateBoardId(String oldValue) {
        return ProjectFeatureMigrator.migrateFeature(oldValue, this.boardIdMigrators);
    }

    public String migrateToolChainId(String oldValue) {
        return ProjectFeatureMigrator.migrateFeature(oldValue, this.toolChainIdMigrators);
    }

    public String migrateExtension(String id, String point) {
        String[] idAndPoint = new String[]{id, point};
        return ProjectFeatureMigrator.migrateFeature(idAndPoint, this.extensionMigrators);
    }

    public String migrateSdkId(String oldValue) {
        return ProjectFeatureMigrator.migrateFeature(oldValue, this.sdkIdMigrators);
    }

    private static <T> String migrateFeature(T input, List<IFeatureMigrator> migrators) {
        if (input == null) {
            return null;
        }
        for (IFeatureMigrator migrator : migrators) {
            String value = (String)migrator.migrateFeature(input);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    private static class SingletonHolder {
        private static final ProjectFeatureMigrator INSTANCE = new ProjectFeatureMigrator();

        static {
            Activator.extRegistry.add((IExtensionManagerHolder)INSTANCE);
            INSTANCE.getExtensionManager().startup();
        }

        private SingletonHolder() {
        }
    }
}

