/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.model.util.manual;

import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.project.api.core.model.MContent;
import com.silabs.ss.framework.project.api.core.model.MEntry;
import com.silabs.ss.framework.project.api.core.model.MFileEntry;
import com.silabs.ss.framework.project.api.core.model.MFolderEntry;
import com.silabs.ss.framework.project.api.core.model.MProject;
import com.silabs.ss.framework.project.api.core.model.ProjectModelFactory;
import com.silabs.ss.framework.project.api.core.model.util.ProjectModelResourceFactoryImpl;
import com.silabs.ss.framework.project.api.core.model.util.ProjectModelSwitch;
import com.silabs.ss.framework.project.internal.core.model.Activator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public final class ProjectModelLoading {
    private ProjectModelLoading() {
    }

    public static String storeMProjectModel(MProject project) throws CoreException {
        ProjectModelResourceFactoryImpl factory = new ProjectModelResourceFactoryImpl();
        Resource rsrc = factory.createResource(null);
        rsrc.getContents().add((Object)project);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            rsrc.save((OutputStream)bos, null);
        }
        catch (IOException e) {
            throw Activator.reporter.newCoreException("failed to convert project model to string", (Throwable)e);
        }
        return new String(bos.toByteArray());
    }

    public static MProject loadProjectModel(java.net.URI uri) throws CoreException {
        URI euri = URI.createURI((String)uri.toString());
        ProjectModelResourceFactoryImpl factory = new ProjectModelResourceFactoryImpl();
        Resource resource = factory.createResource(euri);
        try {
            resource.load(null);
        }
        catch (IOException e) {
            throw Activator.reporter.newCoreException("failed to load " + String.valueOf(uri), (Throwable)e);
        }
        MProject proj = (MProject)resource.getContents().get(0);
        return ProjectModelLoading.formatProjectModel(proj);
    }

    public static MProject loadProjectModel(String content) throws CoreException {
        ProjectModelResourceFactoryImpl factory = new ProjectModelResourceFactoryImpl();
        Resource resource = factory.createResource(null);
        try {
            resource.load((InputStream)new ByteArrayInputStream(content.getBytes()), null);
        }
        catch (IOException e) {
            throw Activator.reporter.newCoreException("failed to load project", (Throwable)e);
        }
        MProject proj = (MProject)resource.getContents().get(0);
        return ProjectModelLoading.formatProjectModel(proj);
    }

    private static MProject formatProjectModel(MProject project) throws CoreException {
        if (project == null) {
            return null;
        }
        new ProjectModelSwitch<Object>(){

            @Override
            public Object caseMFolderEntry(MFolderEntry parent) {
                ArrayList<MFolderEntry> folders = new ArrayList<MFolderEntry>((Collection<MFolderEntry>)parent.getFolders());
                for (MFolderEntry folder : folders) {
                    ProjectModelLoading.expandNestedName(parent, folder);
                }
                ArrayList<MFileEntry> files = new ArrayList<MFileEntry>((Collection<MFileEntry>)parent.getFiles());
                for (MFileEntry file : files) {
                    ProjectModelLoading.expandNestedName(parent, file);
                }
                return null;
            }

            @Override
            public Object defaultCase(EObject object) {
                return null;
            }
        }.doSwitch(project);
        return project;
    }

    private static void expandNestedName(MFolderEntry parent, MEntry entry) {
        Path path = new Path(entry.getName());
        if (path.segmentCount() == 1) {
            return;
        }
        entry.setName(path.lastSegment());
        MFolderEntry newFolder = ProjectModelLoading.findOrCreateEmptyFolder(parent, path.removeLastSegments(1));
        if (entry instanceof MFolderEntry) {
            newFolder.getFolders().add((Object)((MFolderEntry)entry));
            parent.getFolders().remove((Object)entry);
        } else if (entry instanceof MFileEntry) {
            newFolder.getFiles().add((Object)((MFileEntry)entry));
            parent.getFiles().remove((Object)entry);
        }
        if (entry instanceof MContent && ((MContent)entry).getUri() == null) {
            ((MContent)entry).setUri(path.toString());
        }
    }

    private static MFolderEntry findOrCreateEmptyFolder(MFolderEntry parent, IPath dirPath) {
        MFolderEntry entry = parent;
        int i = 0;
        while (i < dirPath.segmentCount()) {
            entry = ProjectModelLoading.findOrCreateEmptyFolder(entry, dirPath.segment(i));
            ++i;
        }
        return entry;
    }

    private static MFolderEntry findOrCreateEmptyFolder(MFolderEntry parent, String folderName) {
        MFolderEntry folder2;
        for (MFolderEntry folder2 : parent.getFolders()) {
            if (!folderName.equalsIgnoreCase(folder2.getName()) || !ProjectModelLoading.isEmptyFolder(folder2)) continue;
            return folder2;
        }
        folder2 = ProjectModelFactory.eINSTANCE.createMFolderEntry();
        folder2.setName(folderName);
        parent.getFolders().add((Object)folder2);
        return folder2;
    }

    private static boolean isEmptyFolder(MFolderEntry folder) {
        if (folder instanceof MContent && !TextUtils.isEmpty((String)((MContent)((Object)folder)).getUri())) {
            return false;
        }
        if (!TextUtils.isEmpty((String)folder.getBoardCompatibility())) {
            return false;
        }
        if (!TextUtils.isEmpty((String)folder.getPartCompatibility())) {
            return false;
        }
        if (!TextUtils.isEmpty((String)folder.getSdkCompatibility())) {
            return false;
        }
        return TextUtils.isEmpty((String)folder.getToolchainCompatibility());
    }
}

