/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.model;

import com.silabs.ss.framework.project.api.core.model.MBuildSetting;
import com.silabs.ss.framework.project.api.core.model.MSelectable;

public final class ProjectObjectMergeUtils {
    private ProjectObjectMergeUtils() {
    }

    public static void applySelectable(MSelectable option, MSelectable select) {
        option.setBoardCompatibility(select.getBoardCompatibility());
        option.setPartCompatibility(select.getPartCompatibility());
        option.setSdkCompatibility(select.getSdkCompatibility());
        option.setToolchainCompatibility(select.getToolchainCompatibility());
        option.setCompatibility(select.getCompatibility());
        option.setBuiltin(select.isBuiltin());
        if (select instanceof MBuildSetting && option instanceof MBuildSetting) {
            ((MBuildSetting)option).setLanguageCompatibility(((MBuildSetting)select).getLanguageCompatibility());
        }
    }

    public static void appendSelectable(MSelectable option, MSelectable select) {
        option.setBoardCompatibility(ProjectObjectMergeUtils.getCompat(option.getBoardCompatibility(), select.getBoardCompatibility()));
        option.setPartCompatibility(ProjectObjectMergeUtils.getCompat(option.getPartCompatibility(), select.getPartCompatibility()));
        option.setSdkCompatibility(ProjectObjectMergeUtils.getCompat(option.getSdkCompatibility(), select.getSdkCompatibility()));
        option.setToolchainCompatibility(ProjectObjectMergeUtils.getCompat(option.getToolchainCompatibility(), select.getToolchainCompatibility()));
        option.setCompatibility(select.getCompatibility());
        option.setBuiltin(select.isBuiltin());
        if (select instanceof MBuildSetting && option instanceof MBuildSetting) {
            ((MBuildSetting)option).setLanguageCompatibility(ProjectObjectMergeUtils.getCompat(((MBuildSetting)option).getLanguageCompatibility(), ((MBuildSetting)select).getLanguageCompatibility()));
        }
    }

    private static String getCompat(String origCompat, String newCompat) {
        if (origCompat == null) {
            return newCompat;
        }
        if (newCompat == null || origCompat.contains(newCompat)) {
            return origCompat;
        }
        return origCompat + " " + newCompat;
    }
}

