/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.model.options;

import com.silabs.ss.framework.project.api.core.model.MConvertedOption;
import com.silabs.ss.framework.project.api.core.model.MSettingsSite;
import com.silabs.ss.framework.project.api.core.model.MSpecificOption;
import com.silabs.ss.framework.project.api.core.model.options.IDirectOptionMapping;
import com.silabs.ss.framework.project.api.core.model.options.IDirectOptionMappingRegistry;
import com.silabs.ss.framework.project.api.core.model.options.IReverseDirectOptionMapping;
import com.silabs.ss.framework.project.internal.core.model.options.BaseOptionMappingEngine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DirectOptionMappingEngine
extends BaseOptionMappingEngine<MSpecificOption, IDirectOptionMapping, IReverseDirectOptionMapping> {
    public DirectOptionMappingEngine(IDirectOptionMappingRegistry mappings) {
        super(MSpecificOption.class, mappings);
    }

    protected void updateSettingsSiteForImport(MSettingsSite settings, MSpecificOption spec, MSpecificOption[] outs) {
        settings.getConvertedOptions().remove((Object)spec);
        settings.getConvertedOptions().addAll(Arrays.asList(outs));
        MSpecificOption[] mSpecificOptionArray = outs;
        int n = outs.length;
        int n2 = 0;
        while (n2 < n) {
            MSpecificOption out = mSpecificOptionArray[n2];
            out.setMappingStatus(spec.getMappingStatus());
            ++n2;
        }
    }

    @Override
    protected boolean outgoingCoversIncoming(MSpecificOption gen, MSpecificOption specific) {
        return gen.getOptionId().equals(specific.getOptionId());
    }

    @Override
    protected List<MSpecificOption> gatherOutgoing(MSettingsSite site) {
        ArrayList<MSpecificOption> outgoingOptionList = null;
        for (MConvertedOption cvt : site.getConvertedOptions()) {
            if (!(cvt instanceof MSpecificOption)) continue;
            MSpecificOption spec = (MSpecificOption)cvt;
            if (outgoingOptionList == null) {
                outgoingOptionList = new ArrayList<MSpecificOption>(1);
            }
            outgoingOptionList.add(spec);
        }
        return outgoingOptionList == null ? Collections.emptyList() : outgoingOptionList;
    }

    @Override
    protected Map<String, MSpecificOption> gatherExistingSpecific(MSettingsSite site) {
        HashMap<String, MSpecificOption> map = new HashMap<String, MSpecificOption>();
        for (MSpecificOption spec : this.gatherOutgoing(site)) {
            map.put(spec.getOptionId(), spec);
        }
        return map;
    }
}

