/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.model.options;

import com.silabs.java.utils.extension.ExtensionManager;
import com.silabs.java.utils.extension.IExtensionElementHandler;
import com.silabs.java.utils.extension.IExtensionInformation;
import com.silabs.java.utils.extension.IExtensionManager;
import com.silabs.java.utils.extension.IExtensionManagerHolder;
import com.silabs.ss.framework.project.api.core.model.options.IGenericBuildOptionsProvider;
import com.silabs.ss.framework.project.api.core.model.options.IGenericBuildOptionsRegistry;
import com.silabs.ss.framework.project.internal.core.model.Activator;
import com.silabs.ss.platform.api.descriptor.core.model.MPropertyGroup;
import com.silabs.ss.platform.api.descriptor.core.property.model.IProperty;
import com.silabs.ss.platform.api.descriptor.core.property.model.IPropertyGroup;
import com.silabs.ss.platform.api.descriptor.core.property.model.Property;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class GenericBuildOptionsRegistry
implements IGenericBuildOptionsRegistry,
IExtensionManagerHolder {
    protected static final String CONVERTER_ELEMENT = "converter";
    protected static final String OPTIONS_GROUP = "optionsGroup";
    protected static final String OPTIONS_CLASS = "optionsClass";
    protected static final String ATTR_PROPERTY_GROUP = "propertyGroup";
    protected static final String ATTR_CLASS = "class";
    private IExtensionManager extMgr;
    private Map<String, MPropertyGroup> optionGroups = new HashMap<String, MPropertyGroup>();

    public static GenericBuildOptionsRegistry create() {
        return new GenericBuildOptionsRegistry((IExtensionManager)new ExtensionManager(Activator.id(), "genericBuildOptionsSupport", null));
    }

    private GenericBuildOptionsRegistry(IExtensionManager extensionManager) {
        this.extMgr = extensionManager;
        this.extMgr.addHandler(OPTIONS_GROUP, new IExtensionElementHandler(){

            public void handle(IExtensionInformation element, boolean added, Object context) throws Exception {
                String propGroupName = element.getAttribute(GenericBuildOptionsRegistry.ATTR_PROPERTY_GROUP);
                if (added) {
                    GenericBuildOptionsRegistry.this.registerOptionGroup(propGroupName);
                } else {
                    GenericBuildOptionsRegistry.this.removeOptionGroup(propGroupName);
                }
            }
        });
        this.extMgr.addHandler(OPTIONS_CLASS, new IExtensionElementHandler(){

            public void handle(IExtensionInformation element, boolean added, Object context) throws Exception {
                IGenericBuildOptionsProvider provider = (IGenericBuildOptionsProvider)element.createExecutableExtension(GenericBuildOptionsRegistry.ATTR_CLASS);
                if (added) {
                    provider.registerGroups();
                } else {
                    provider.removeGroups();
                }
            }
        });
    }

    public IExtensionManager getExtensionManager() {
        return this.extMgr;
    }

    @Override
    public IPropertyGroup[] getAllOptionGroups() {
        ArrayList<IPropertyGroup> groups = new ArrayList<IPropertyGroup>();
        for (MPropertyGroup mpg : this.optionGroups.values()) {
            IPropertyGroup group = Property.registry().realizePropertyGroup(mpg);
            if (group == null) continue;
            groups.add(group);
        }
        return groups.toArray(new IPropertyGroup[groups.size()]);
    }

    @Override
    public IProperty[] getAllOptions() {
        ArrayList<IProperty> props = new ArrayList<IProperty>();
        for (MPropertyGroup mpg : this.optionGroups.values()) {
            IPropertyGroup group = Property.registry().realizePropertyGroup(mpg);
            if (group == null) continue;
            props.addAll(Arrays.asList(group.getProperties()));
        }
        return props.toArray(new IProperty[props.size()]);
    }

    @Override
    public void registerOptionGroup(String groupId) {
        MPropertyGroup group = Property.registry().findMPropertyGroup(groupId);
        if (group == null) {
            Activator.reporter.logError("no property group named '" + groupId + "' registered");
        } else {
            this.optionGroups.put(groupId, group);
        }
    }

    @Override
    public void removeOptionGroup(String groupId) {
        this.optionGroups.remove(groupId);
    }

    @Override
    public IProperty findGenericOption(String toolId, String optionId) {
        if (!this.optionGroups.containsKey(toolId)) {
            return null;
        }
        IProperty prop = (IProperty)Property.registry().findDescriptor(optionId);
        if (prop == null) {
            prop = (IProperty)Property.registry().findDescriptor(toolId + "." + optionId);
        }
        if (!(prop == null || prop.getParent() != null && ((IPropertyGroup)prop.getParent()).getId().equals(toolId))) {
            return null;
        }
        return prop;
    }
}

