/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.model.options;

import com.silabs.ss.framework.project.internal.core.model.options.ValueOptionMappingAtom;
import com.silabs.ss.platform.api.descriptor.core.property.model.IProperty;
import java.util.Map;

public class VariableValueOptionMappingAtom
extends ValueOptionMappingAtom {
    private static final String MAPPING_SPLIT_CHAR = "%1";
    private Map<String, String> replacements;

    public VariableValueOptionMappingAtom(Map<String, String> replacements, IProperty genericOption, Object genericValue) {
        super(genericOption, genericValue);
        this.replacements = replacements;
    }

    @Override
    protected String convertOutgoingString(String specValStr_) {
        String cvt = specValStr_;
        for (Map.Entry<String, String> ent : this.replacements.entrySet()) {
            cvt = this.handleBasicReplacement(cvt, ent.getKey(), ent.getValue());
            cvt = this.handleComplexReplacement(cvt, ent.getKey(), ent.getValue());
        }
        return cvt;
    }

    @Override
    protected String convertIncomingString(String genValStr_) {
        String cvt = genValStr_;
        for (Map.Entry<String, String> ent : this.replacements.entrySet()) {
            cvt = this.handleBasicReplacement(cvt, ent.getValue(), ent.getKey());
            cvt = this.handleComplexReplacement(cvt, ent.getValue(), ent.getKey());
        }
        return cvt;
    }

    private String handleComplexReplacement(String cvt, String toReplaceStr, String replaceWithStr) {
        if (!this.isVariableReplacement(toReplaceStr, replaceWithStr)) {
            return cvt;
        }
        String[] toReplace = this.splitReplacements(toReplaceStr);
        String[] replaceWith = this.splitReplacements(replaceWithStr);
        int idx0 = cvt.indexOf(toReplace[0]);
        int idx1 = cvt.indexOf(toReplace[1]);
        if (idx0 < 0 || idx1 < 0) {
            return cvt;
        }
        Object cvtRepl = cvt;
        cvtRepl = toReplace[0].isEmpty() ? replaceWith[0] + (String)cvtRepl : ((String)cvtRepl).replace(toReplace[0], replaceWith[0]);
        cvtRepl = toReplace[1].isEmpty() ? (String)cvtRepl + replaceWith[1] : ((String)cvtRepl).replace(toReplace[1], replaceWith[1]);
        return cvtRepl;
    }

    private String[] splitReplacements(String replace) {
        int idx = replace.indexOf(MAPPING_SPLIT_CHAR);
        if (idx < 0) {
            return new String[]{replace, ""};
        }
        return new String[]{replace.substring(0, idx), replace.substring(idx + 2, replace.length())};
    }

    private String handleBasicReplacement(String cvt, String toReplace, String replaceWith) {
        if (!cvt.contains(toReplace) || this.isVariableReplacement(toReplace, replaceWith)) {
            return cvt;
        }
        return cvt.replace(toReplace, replaceWith);
    }

    private boolean isVariableReplacement(String toReplace, String replaceWith) {
        return toReplace.contains(MAPPING_SPLIT_CHAR) || replaceWith.contains(MAPPING_SPLIT_CHAR);
    }

    @Override
    public String toString() {
        return "VariableValueOptionMappingAtom [outgoingOption=" + String.valueOf(this.outgoingOption) + ", outgoingValue=" + String.valueOf(this.outgoingValue) + "]";
    }
}

