/*
 * Decompiled with CFR 0.152.
 */
package com.arm.cmsis.parser;

import com.arm.cmsis.config.Messages;
import com.arm.cmsis.config.model.ConfigWizardItem;
import com.arm.cmsis.config.model.IConfigWizardItem;
import com.arm.cmsis.parser.ConfigWizardScanner;
import com.arm.cmsis.parser.HeaderModel;
import com.arm.cmsis.utils.Utils;
import com.silabs.jface.text.rules.IHeaderContent;
import com.silabs.jface.text.rules.IToken;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.osgi.util.NLS;

public class ConfigWizardParser {
    private static final String INT_OR_INT_RANGE = "\\d+((\\.\\d+)?|(\\.\\d+(\\.\\.\\d+)?))";
    private static final String C_IDENTIFIER = "[a-zA-Z_][a-zA-Z0-9_]*";
    private static final int LAST_CONFIG_WIZARD_START_LINE = 100;
    private ConfigWizardScanner fScanner;
    private boolean fContainWizard;
    private int fParsingErrorOffset;
    private int fStartParseOffset;
    private int fEndParseOffset;
    private IToken cToken;
    private ConfigWizardScanner.ETokenType cType;
    String fParsingErrorMessage = null;
    private HeaderModel headerModel;
    private final String CorrectTokenFormatMsg = Messages.getString("ConfigWizardParser_CorrectTokenFormat");
    private final String FailToParseModifierMsg = Messages.getString("ConfigWizardParser_FailToParseModifierNumber");
    private IErrorListener validationErrorListener = null;
    private IErrorListener syntaxErrorListener = null;

    public ConfigWizardParser(IHeaderContent<? extends Object> document) {
        this(new ConfigWizardScanner(), document);
    }

    public ConfigWizardParser(ConfigWizardScanner scanner, IHeaderContent<? extends Object> document) {
        this.fScanner = scanner;
        this.fContainWizard = false;
        this.headerModel = new HeaderModel(document);
        this.initialize();
    }

    public void setValidationErrorListener(IErrorListener validationErrorListener) {
        this.validationErrorListener = validationErrorListener;
    }

    public void setSyntaxErrorListener(IErrorListener syntaxErrorListener) {
        this.syntaxErrorListener = syntaxErrorListener;
    }

    private void clear() {
        this.fScanner.clear();
        this.fParsingErrorOffset = -1;
        this.fContainWizard = false;
        this.fStartParseOffset = this.fEndParseOffset = this.headerModel.getDocumentLength();
        this.cToken = null;
        this.cType = null;
        this.headerModel.clearMaps();
    }

    private void initialize() {
        this.fStartParseOffset = this.fEndParseOffset = this.headerModel.getDocumentLength();
        this.findConfigurationWizard();
    }

    public IConfigWizardItem parse() {
        this.clear();
        this.setParseRange(0, this.headerModel.getDocumentLength());
        return this.doParse();
    }

    public HeaderModel getHeaderModel() {
        return this.headerModel;
    }

    public String getParsingErrorMessage() {
        return this.fParsingErrorMessage;
    }

    private boolean findConfigurationWizard() {
        int docLength = this.headerModel.getDocumentLength();
        int offset = this.headerModel.getLineOffset(100);
        if (offset == -1) {
            offset = docLength;
        }
        this.clear();
        this.setParseRange(0, offset);
        IToken token = this.fScanner.nextToken();
        while (!token.isEOF() && this.fScanner.getTokenType(token) != ConfigWizardScanner.ETokenType.START) {
            token = this.fScanner.nextToken();
        }
        this.fContainWizard = this.fScanner.getTokenType(token) == ConfigWizardScanner.ETokenType.START;
        return this.fContainWizard;
    }

    private void setParseRange(int start, int end) {
        this.fScanner.setRange(this.headerModel.getDocument(), start, end);
    }

    private IConfigWizardItem doParse() {
        this.headerModel.createRootItem("Root");
        IToken token = this.fScanner.nextToken();
        while (!token.isEOF() && this.fScanner.getTokenType(token) != ConfigWizardScanner.ETokenType.START) {
            token = this.fScanner.nextToken();
        }
        if (token.isEOF()) {
            return null;
        }
        this.fContainWizard = true;
        this.fStartParseOffset = this.fScanner.getTokenOffset();
        IConfigWizardItem root = this.parseItems(this.headerModel.getRootItem(), ConfigWizardScanner.ETokenType.EOC);
        if (root == null) {
            this.headerModel.clearRootItem();
        }
        if (this.headerModel.getRootItem() != null) {
            List<String> errors = this.validate();
            if (errors.size() > 0) {
                this.validationErrors(errors);
            }
            this.setValuesAndStrings();
        }
        return this.headerModel.getRootItem();
    }

    private IConfigWizardItem parseItems(IConfigWizardItem parent, ConfigWizardScanner.ETokenType endToken) {
        this.getNextToken();
        while (this.cType != ConfigWizardScanner.ETokenType.EOC && this.cType != ConfigWizardScanner.ETokenType.HEADING_END && this.cType != ConfigWizardScanner.ETokenType.HEADING_ENABLE_END && this.cType != ConfigWizardScanner.ETokenType.CODE_END) {
            ConfigWizardScanner.ETokenType type = this.cType;
            IConfigWizardItem child = this.parseItem(parent);
            if (child == null || this.cType == ConfigWizardScanner.ETokenType.UNKNOWN || this.cType == ConfigWizardScanner.ETokenType.COMMENT || this.cType == ConfigWizardScanner.ETokenType.BLOCK_COMMENT) {
                if (this.fParsingErrorOffset == -1) {
                    this.syntaxError(NLS.bind((String)Messages.getString("ConfigWizardParser_WrongTokenFormat"), (Object)this.fScanner.getTokenContent(this.cToken)));
                }
                return null;
            }
            if (ConfigWizardScanner.ETokenType.isSecondary(type)) continue;
            parent.addChild(child);
        }
        if (this.cType == endToken) {
            parent.setEndLine(this.fScanner.getCurrentLineNumber());
            if (this.cType == ConfigWizardScanner.ETokenType.CODE_END) {
                parent = this.analyseCodeContent(parent);
            }
            return parent;
        }
        if (endToken == ConfigWizardScanner.ETokenType.EOC) {
            this.fEndParseOffset = this.fScanner.getTokenOffset();
        }
        this.syntaxError(Messages.getString("ConfigWizardParser_WrongEndingToken") + this.getTokenTypeString(endToken) + Messages.getString("ConfigWizardParser_RealIs") + this.getTokenTypeString(this.cType));
        return null;
    }

    private IConfigWizardItem parseItem(IConfigWizardItem parent) {
        switch (this.cType) {
            case HEADING: {
                return this.parseHeading(parent);
            }
            case HEADING_ENABLE: {
                return this.parseHeadingEnable(parent);
            }
            case CODE_ENABLE: 
            case CODE_DISABLE: {
                return this.parseCodeComment(parent);
            }
            case OPTION: {
                ConfigWizardItem item = new ConfigWizardItem(IConfigWizardItem.EItemType.OPTION, this.fScanner.getCurrentLineNumber(), parent);
                return this.parseOption(item);
            }
            case OPTION_CHECK: {
                ConfigWizardItem item = new ConfigWizardItem(IConfigWizardItem.EItemType.OPTION_CHECK, this.fScanner.getCurrentLineNumber(), parent);
                return this.parseOption(item);
            }
            case OPTION_STRING: {
                ConfigWizardItem item = new ConfigWizardItem(IConfigWizardItem.EItemType.OPTION_STRING, this.fScanner.getCurrentLineNumber(), parent);
                return this.parseOptionString(item);
            }
            case NOTIFICATION: {
                ConfigWizardItem item = new ConfigWizardItem(IConfigWizardItem.EItemType.NOTIFICATION, this.fScanner.getCurrentLineNumber(), parent);
                return this.parseNotification(item);
            }
            case TOOLTIP: {
                IConfigWizardItem item = parent.getLastChild();
                if (item == null) {
                    item = parent;
                }
                return this.parseTooltip(item);
            }
            case NUMBER: {
                this.parseNumber();
                return parent;
            }
            case MACROVALUE: {
                this.parseMacroValue();
                return parent;
            }
            case START: {
                this.getNextToken();
                return parent;
            }
            case ARRAY: {
                ConfigWizardItem item = new ConfigWizardItem(IConfigWizardItem.EItemType.ARRAY, this.fScanner.getCurrentLineNumber(), parent);
                return this.parseArray(item);
            }
            case DEFAULTVALUE: {
                IConfigWizardItem item = parent.getLastChild();
                if (item == null && (parent.getItemType() == IConfigWizardItem.EItemType.HEADING_ENABLE || parent.getItemType() == IConfigWizardItem.EItemType.OPTION_CHECK)) {
                    item = parent;
                }
                if (item != null) {
                    item = this.parseDefaultValue(item);
                }
                return item;
            }
            case FORMAT: {
                IConfigWizardItem item = parent.getLastChild();
                if (item != null) {
                    item = this.parseFormat(item);
                }
                return item;
            }
            case VALUE: {
                IConfigWizardItem item = parent.getLastChild();
                if (item != null && (item.getItemType() == IConfigWizardItem.EItemType.OPTION || item.getItemType() == IConfigWizardItem.EItemType.OPTION_SELECT)) {
                    item = this.parseSelection(item);
                }
                return item;
            }
        }
        this.syntaxError(NLS.bind((String)Messages.getString("ConfigWizardParser_UnknownTokenType"), (Object)this.fScanner.getTokenContent(this.cToken)));
        return null;
    }

    private IConfigWizardItem parseHeading(IConfigWizardItem parent) {
        Assert.isTrue((this.cType == ConfigWizardScanner.ETokenType.HEADING ? 1 : 0) != 0);
        String tokenContent = this.fScanner.getTokenContent(this.cToken);
        if (!tokenContent.equalsIgnoreCase("h")) {
            this.syntaxError(Messages.getString("ConfigWizardParser_WrongHeadTokenFormat") + tokenContent + this.CorrectTokenFormatMsg + "<h>");
            return null;
        }
        IConfigWizardItem heading = new ConfigWizardItem(IConfigWizardItem.EItemType.HEADING, this.fScanner.getCurrentLineNumber(), parent);
        heading.setName(this.fScanner.readLine());
        heading = this.parseItems(heading, ConfigWizardScanner.ETokenType.HEADING_END);
        this.getNextToken();
        return heading;
    }

    private IConfigWizardItem parseHeadingEnable(IConfigWizardItem parent) {
        Assert.isTrue((this.cType == ConfigWizardScanner.ETokenType.HEADING_ENABLE ? 1 : 0) != 0);
        IConfigWizardItem headingEnable = new ConfigWizardItem(IConfigWizardItem.EItemType.HEADING_ENABLE, this.fScanner.getCurrentLineNumber(), parent);
        String tokenContent = this.fScanner.getTokenContent(this.cToken);
        headingEnable = this.parseModifier(headingEnable, tokenContent.substring(1));
        if (headingEnable != null) {
            headingEnable.setName(this.fScanner.readLine());
            headingEnable = this.parseItems(headingEnable, ConfigWizardScanner.ETokenType.HEADING_ENABLE_END);
        }
        this.getNextToken();
        return headingEnable;
    }

    private IConfigWizardItem parseCodeComment(IConfigWizardItem parent) {
        Assert.isTrue((this.cType == ConfigWizardScanner.ETokenType.CODE_ENABLE || this.cType == ConfigWizardScanner.ETokenType.CODE_DISABLE ? 1 : 0) != 0);
        IConfigWizardItem.EItemType itemType = IConfigWizardItem.EItemType.CODE_ENABLE;
        if (this.cType == ConfigWizardScanner.ETokenType.CODE_DISABLE) {
            itemType = IConfigWizardItem.EItemType.CODE_DISABLE;
        }
        IConfigWizardItem codeComment = new ConfigWizardItem(itemType, this.fScanner.getCurrentLineNumber(), parent);
        String tokenContent = this.fScanner.getTokenContent(this.cToken);
        String modifier = tokenContent.substring(1);
        if (itemType == IConfigWizardItem.EItemType.CODE_DISABLE) {
            codeComment.setInvertValue(true);
            modifier = tokenContent.substring(2);
        }
        if ((codeComment = this.parseModifier(codeComment, modifier)) != null) {
            codeComment.setName(this.fScanner.readLine());
            codeComment = this.parseItems(codeComment, ConfigWizardScanner.ETokenType.CODE_END);
        }
        this.getNextToken();
        return codeComment;
    }

    private IConfigWizardItem parseModifier(IConfigWizardItem item, String modifier) {
        item.setMinBit(0);
        item.setMaxBit(63);
        item.setSkipNumber(0);
        item.setMinValue(Long.MIN_VALUE);
        item.setMaxValue(Long.MAX_VALUE);
        item.setBase(16);
        if (((String)modifier).length() == 0) {
            return item;
        }
        if (((String)modifier).startsWith(".")) {
            modifier = "0" + (String)modifier;
        }
        if (((String)modifier).matches(INT_OR_INT_RANGE)) {
            try {
                int dotPos = ((String)modifier).indexOf(46);
                if (dotPos == -1) {
                    dotPos = ((String)modifier).length();
                }
                int skipNumber = Integer.parseInt(((String)modifier).substring(0, dotPos));
                item.setSkipNumber(skipNumber);
                if (dotPos == ((String)modifier).length()) {
                    return item;
                }
                int ddotPos = ((String)modifier).indexOf("..");
                if (ddotPos == -1) {
                    ddotPos = ((String)modifier).length();
                }
                int minBit = Integer.parseInt(((String)modifier).substring(dotPos + 1, ddotPos));
                item.setMinBit(minBit);
                item.setMaxBit(minBit);
                if (ddotPos == ((String)modifier).length()) {
                    if (item.getItemType() == IConfigWizardItem.EItemType.OPTION) {
                        item.setItemType(IConfigWizardItem.EItemType.OPTION_CHECK);
                    }
                    return item;
                }
                int maxBit = Integer.parseInt(((String)modifier).substring(ddotPos + 2, ((String)modifier).length()));
                if (maxBit < minBit) {
                    maxBit = minBit;
                }
                item.setMaxBit(maxBit);
                if (item.getMinBit() == item.getMaxBit() && item.getItemType() == IConfigWizardItem.EItemType.OPTION) {
                    item.setItemType(IConfigWizardItem.EItemType.OPTION_CHECK);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.syntaxError(this.FailToParseModifierMsg + (String)modifier);
                return null;
            }
            return item;
        }
        if (((String)modifier).matches(C_IDENTIFIER)) {
            item.setMacroName((String)modifier);
            return item;
        }
        if (!((String)modifier).matches(INT_OR_INT_RANGE)) {
            this.syntaxError(Messages.getString("ConfigWizardParser_WrongModificationFormat") + (String)modifier + this.CorrectTokenFormatMsg + "\\d+((\\.\\d+)?|(\\.\\d+(\\.\\.\\d+)?)) or [a-zA-Z_][a-zA-Z0-9_]*");
        }
        return null;
    }

    private IConfigWizardItem parseOption(IConfigWizardItem item) {
        Assert.isTrue((this.cType == ConfigWizardScanner.ETokenType.OPTION || this.cType == ConfigWizardScanner.ETokenType.OPTION_CHECK ? 1 : 0) != 0);
        String tokenContent = this.fScanner.getTokenContent(this.cToken);
        item = this.parseModifier(item, tokenContent.substring(1));
        if (item != null) {
            item.setName(this.fScanner.readString());
            this.getNextToken();
            while (this.cType == ConfigWizardScanner.ETokenType.TOOLTIP) {
                this.parseTooltip(item);
            }
            if (this.cType != ConfigWizardScanner.ETokenType.EOC) {
                tokenContent = this.fScanner.getTokenContent(this.cToken);
                if (this.cType == ConfigWizardScanner.ETokenType.FORMAT && this.parseFormat(item) == null) {
                    return null;
                }
                if (this.parseRangeOrSelection(item, tokenContent) == null) {
                    return null;
                }
                if (!item.isSelection() && this.parseModification(item, tokenContent = this.fScanner.getTokenContent(this.cToken)) == null) {
                    return null;
                }
            }
        }
        return item;
    }

    private IConfigWizardItem parseRangeOrSelection(IConfigWizardItem item, String rangeOrSelection) {
        item.setBase(16);
        if (!(rangeOrSelection.matches("(0[xX][0-9a-fA-F]+|\\d+)-(0[xX][0-9a-fA-F]+|\\d+)(:(0[xX][0-9a-fA-F]+|\\d+))?") || rangeOrSelection.matches("-?(0[xX][0-9a-fA-F]+|\\d+)..-?(0[xX][0-9a-fA-F]+|\\d+)(:(0[xX][0-9a-fA-F]+|\\d+))?") || rangeOrSelection.matches("(0[xX][0-9a-fA-F]+|\\d+)=") || rangeOrSelection.matches("[a-zA-Z_][a-zA-Z0-9_]*="))) {
            return item;
        }
        if (!rangeOrSelection.toLowerCase().contains("0x")) {
            item.setBase(10);
            item.setMinValue(Long.MIN_VALUE);
        }
        try {
            if (rangeOrSelection.matches("(0[xX][0-9a-fA-F]+|\\d+)-(0[xX][0-9a-fA-F]+|\\d+)(:(0[xX][0-9a-fA-F]+|\\d+))?") || rangeOrSelection.matches("-?(0[xX][0-9a-fA-F]+|\\d+)..-?(0[xX][0-9a-fA-F]+|\\d+)(:(0[xX][0-9a-fA-F]+|\\d+))?")) {
                String sep = "";
                if (rangeOrSelection.matches("(0[xX][0-9a-fA-F]+|\\d+)-(0[xX][0-9a-fA-F]+|\\d+)(:(0[xX][0-9a-fA-F]+|\\d+))?")) {
                    sep = "-";
                } else if (rangeOrSelection.matches("-?(0[xX][0-9a-fA-F]+|\\d+)..-?(0[xX][0-9a-fA-F]+|\\d+)(:(0[xX][0-9a-fA-F]+|\\d+))?")) {
                    sep = "..";
                }
                int sepPos = rangeOrSelection.indexOf(sep);
                long minValue = ConfigWizardParser.parseRangeStr(rangeOrSelection.substring(0, sepPos));
                item.setMinValue(minValue);
                item.setMaxValue(minValue);
                int colPos = rangeOrSelection.indexOf(58);
                if (colPos == -1) {
                    colPos = rangeOrSelection.length();
                }
                long maxValue = ConfigWizardParser.parseRangeStr(rangeOrSelection.substring(sepPos + sep.length(), colPos));
                item.setMaxValue(maxValue);
                if (colPos < rangeOrSelection.length()) {
                    long spinStep = ConfigWizardParser.parseRangeStr(rangeOrSelection.substring(colPos + 1));
                    item.setSpinStep(spinStep);
                }
            } else {
                item = this.parseSelection(item);
                return item;
            }
            this.getNextToken();
            return item;
        }
        catch (NumberFormatException numberFormatException) {
            this.syntaxError(this.getRangeSelectionErrorMsg(rangeOrSelection, "(0[xX][0-9a-fA-F]+|\\d+)-(0[xX][0-9a-fA-F]+|\\d+)(:(0[xX][0-9a-fA-F]+|\\d+))?", "(0[xX][0-9a-fA-F]+|\\d+)="));
            return null;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            this.syntaxError(this.getRangeSelectionErrorMsg(rangeOrSelection, "-?(0[xX][0-9a-fA-F]+|\\d+)..-?(0[xX][0-9a-fA-F]+|\\d+)(:(0[xX][0-9a-fA-F]+|\\d+))?", "(0[xX][0-9a-fA-F]+|\\d+)="));
            return null;
        }
        catch (Exception exception) {
            String otherException = Messages.getString("ConfigWizardParser_UnknownRangeSelectionParsingException");
            String errorMsg = NLS.bind((String)otherException, (Object[])new Object[]{this.headerModel.getDocument().getContent().toString()});
            this.syntaxError(errorMsg);
            return null;
        }
    }

    private String getRangeSelectionErrorMsg(String rangeOrSelection, String posOrNegRangeRegex, String selectRegex) {
        StringBuilder sb = new StringBuilder();
        sb.append(Messages.getString("ConfigWizardParser_WrongRangeSelectionFormat"));
        sb.append(rangeOrSelection);
        sb.append(this.CorrectTokenFormatMsg);
        sb.append(posOrNegRangeRegex);
        sb.append(Messages.getString("ConfigWizardParser_Range"));
        sb.append(selectRegex);
        sb.append(Messages.getString("ConfigWizardParser_Selection"));
        return sb.toString();
    }

    private static long parseRangeStr(String str) {
        int radix;
        String hexPrefix = "0x";
        int n = radix = str.toLowerCase().contains(hexPrefix) ? 16 : 10;
        if (radix == 16) {
            str = str.replaceFirst(hexPrefix, "");
        }
        long value = Long.parseLong(str, radix);
        return value;
    }

    private IConfigWizardItem parseSelection(IConfigWizardItem item) {
        Assert.isTrue((this.cType == ConfigWizardScanner.ETokenType.VALUE ? 1 : 0) != 0);
        item.setIsSelection(true);
        item.setItemType(IConfigWizardItem.EItemType.OPTION_SELECT);
        while (this.cType == ConfigWizardScanner.ETokenType.VALUE) {
            String value = this.fScanner.getTokenContent(this.cToken);
            int equPos = value.indexOf(61);
            String tokenStr = value.substring(0, equPos);
            int radix = 10;
            String number = tokenStr.toLowerCase();
            if (number.startsWith("0x")) {
                radix = 16;
                number = number.substring(2);
            }
            boolean foundLong = false;
            try {
                long key = Long.parseLong(number, radix);
                String name = this.fScanner.readString();
                item.addItem(key, name);
                foundLong = true;
            }
            catch (Exception exception) {}
            if (!foundLong && tokenStr.matches(C_IDENTIFIER)) {
                String label = this.fScanner.readString();
                item.addIdentifierItem(tokenStr, label);
            }
            this.getNextToken();
        }
        if (this.cType == ConfigWizardScanner.ETokenType.UNKNOWN) {
            this.syntaxError(NLS.bind((String)Messages.getString("ConfigWizardParser_WrongSelectionToken"), (Object)this.fScanner.getTokenContent(this.cToken)) + this.CorrectTokenFormatMsg + this.getTokenTypeString(ConfigWizardScanner.ETokenType.VALUE));
            return null;
        }
        return item;
    }

    private IConfigWizardItem parseModification(IConfigWizardItem item, String modification) {
        String regex = "#(\\+|-|\\*|/)(0[xX]|)[\\dA-Fa-f]+";
        if (modification.matches(regex)) {
            try {
                char m = modification.charAt(1);
                item.setModification(m);
                int radix = 10;
                String number = modification.substring(2).toLowerCase();
                if (number.startsWith("0x")) {
                    radix = 16;
                    number = number.substring(2);
                }
                long modifier = Long.parseLong(number, radix);
                if ((m == '/' || m == '*') && modifier == 0L) {
                    modifier = 1L;
                }
                item.setModifier(modifier);
                this.getNextToken();
            }
            catch (NumberFormatException numberFormatException) {
                this.syntaxError(Messages.getString("ConfigWizardParser_WrongModificationFormat") + modification + this.CorrectTokenFormatMsg + regex);
                return null;
            }
        }
        return item;
    }

    private IConfigWizardItem parseTooltip(IConfigWizardItem item) {
        Assert.isTrue((this.cType == ConfigWizardScanner.ETokenType.TOOLTIP ? 1 : 0) != 0);
        if (item == null) {
            this.syntaxError(Messages.getString("ConfigWizardParser_TooltipForUnknownConfigItem"));
            return null;
        }
        String moreTooltip = this.fScanner.readLine();
        item.extendTooltip(moreTooltip);
        this.getNextToken();
        return item;
    }

    private IConfigWizardItem parseOptionString(IConfigWizardItem item) {
        Assert.isTrue((this.cType == ConfigWizardScanner.ETokenType.OPTION_STRING ? 1 : 0) != 0);
        String tokenContent = this.fScanner.getTokenContent(this.cToken);
        item = this.parseStringModifier(item, tokenContent.substring(1));
        if (item != null) {
            String name = this.fScanner.readString();
            item.setName(name);
            this.getNextToken();
            while (this.cType == ConfigWizardScanner.ETokenType.TOOLTIP) {
                this.parseTooltip(item);
            }
        }
        return item;
    }

    private IConfigWizardItem parseStringModifier(IConfigWizardItem item, String modifier) {
        if (((String)modifier).length() == 0) {
            return item;
        }
        if (((String)modifier).startsWith(".")) {
            modifier = "0" + (String)modifier;
        }
        String identifier = null;
        int index = 0;
        while (index < ((String)modifier).length()) {
            char ch = ((String)modifier).charAt(index);
            if (ch != '.' && ('0' > ch || ch > '9')) {
                identifier = ((String)modifier).substring(index);
                modifier = ((String)modifier).substring(0, index);
                break;
            }
            ++index;
        }
        if (((String)modifier).length() > 0 && !this.processStringModifier(item, (String)modifier)) {
            return null;
        }
        if (identifier != null && identifier.matches(C_IDENTIFIER)) {
            item.setMacroName(identifier);
            if (item.getSkipNumber() > 0) {
                this.syntaxError("Cannot specify skip value and identifier: " + item.getSkipNumber() + " " + identifier);
                return null;
            }
        }
        return item;
    }

    private boolean processStringModifier(IConfigWizardItem item, String modifier) {
        if (!modifier.matches("\\d+(\\.\\d+)?")) {
            this.syntaxError(Messages.getString("ConfigWizardParser_WrongModifierFormat") + modifier + this.CorrectTokenFormatMsg + "\\d+(\\.\\d+)?");
            return false;
        }
        try {
            int dotPos = modifier.indexOf(46);
            if (dotPos == -1) {
                dotPos = modifier.length();
            }
            int skipNumber = Integer.parseInt(modifier.substring(0, dotPos));
            item.setSkipNumber(skipNumber);
            if (dotPos != modifier.length()) {
                int length = Integer.parseInt(modifier.substring(dotPos + 1));
                item.setStringLength(length);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.syntaxError(this.FailToParseModifierMsg + modifier);
            return false;
        }
        return true;
    }

    private IConfigWizardItem parseNotification(IConfigWizardItem item) {
        item.setName(this.fScanner.readLine());
        this.getNextToken();
        while (this.cType == ConfigWizardScanner.ETokenType.TOOLTIP) {
            this.parseTooltip(item);
        }
        return item;
    }

    private void parseNumber() {
        String tokenContent = this.fScanner.getTokenContent(this.cToken);
        this.headerModel.putNumber(this.fScanner.getTokenOffset(), tokenContent);
        this.getNextToken();
    }

    private void parseMacroValue() {
        String tokenContent = this.fScanner.getTokenContent(this.cToken);
        int first = "define".length();
        while (tokenContent.charAt(first) == ' ' || tokenContent.charAt(first) == '\t') {
            if (++first == tokenContent.length()) break;
        }
        int last = first;
        while ("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_".indexOf(tokenContent.charAt(last)) > -1) {
            ++last;
        }
        String macroName = tokenContent.substring(first, last).trim();
        int start = last;
        while (tokenContent.charAt(start) == ' ' || tokenContent.charAt(start) == '\t') {
            ++start;
        }
        String valueStrPossibleQuote = tokenContent.substring(start);
        String valueStr = null;
        int startQuote = valueStrPossibleQuote.indexOf(34);
        int endQuote = valueStrPossibleQuote.lastIndexOf(34);
        if (startQuote != -1 && endQuote != startQuote) {
            valueStr = valueStrPossibleQuote.substring(startQuote + 1, endQuote);
            start += startQuote + 1;
        } else {
            valueStr = valueStrPossibleQuote;
        }
        int offset = this.fScanner.getTokenOffset() + start;
        this.headerModel.putMacro(offset, macroName);
        this.headerModel.putString(offset, valueStr);
        this.getNextToken();
    }

    private IConfigWizardItem parseArray(IConfigWizardItem item) {
        String tokenContent = this.fScanner.getTokenContent(this.cToken);
        if ((item = this.parseArray(item, tokenContent.substring(1))) != null) {
            while (this.cType == ConfigWizardScanner.ETokenType.TOOLTIP) {
                this.parseTooltip(item);
            }
        } else {
            this.getNextToken();
        }
        return item;
    }

    private IConfigWizardItem parseArray(IConfigWizardItem item, String content) {
        String nameStr;
        if (!".".equals(content.substring(0, 1))) {
            throw new IllegalArgumentException("Expecting '.' after array token");
        }
        String firstGroup = content.substring(1);
        int index = -1;
        int i = 0;
        while (i < firstGroup.length()) {
            if (!Character.isDigit(firstGroup.charAt(i))) {
                index = i;
                break;
            }
            ++i;
        }
        String lenStr = index == -1 ? firstGroup : firstGroup.substring(0, index);
        try {
            int len = Integer.parseInt(lenStr);
            item.setArrayLength(len);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid array length value: " + lenStr);
        }
        if (index > -1 && (firstGroup = firstGroup.substring(index)).matches(C_IDENTIFIER)) {
            item.setMacroName(firstGroup);
        }
        if ((index = (nameStr = this.fScanner.readString()).indexOf(60)) > -1) {
            item.setName(nameStr.substring(0, index).trim());
        } else {
            item.setName(nameStr);
        }
        this.getNextToken();
        if (this.cType == ConfigWizardScanner.ETokenType.UNKNOWN) {
            String rangeExpr;
            String rangeStr = this.fScanner.getTokenContent(this.cToken);
            if (rangeStr.matches(rangeExpr = "[-]?\\d+\\.\\.[-]?\\d+?")) {
                try {
                    int ddotPos = rangeStr.indexOf("..");
                    int rngMin = Integer.parseInt(rangeStr.substring(0, ddotPos));
                    item.setMinValue(rngMin);
                    int rngMax = Integer.parseInt(rangeStr.substring(ddotPos + 2, rangeStr.length()));
                    item.setMaxValue(rngMax);
                }
                catch (NumberFormatException numberFormatException) {
                    this.syntaxError(this.FailToParseModifierMsg + rangeStr);
                    return null;
                }
            }
            this.getNextToken();
        }
        if (this.cType == ConfigWizardScanner.ETokenType.FORMAT) {
            item = this.parseFormat(item);
        }
        return item;
    }

    private IConfigWizardItem parseDefaultValue(IConfigWizardItem item) {
        String defaultValueStr = this.fScanner.readLine();
        if (item.getItemType() == IConfigWizardItem.EItemType.ARRAY) {
            item = this.processArrayDefault(item, defaultValueStr);
        } else if (item.getItemType() == IConfigWizardItem.EItemType.OPTION || item.getItemType() == IConfigWizardItem.EItemType.HEADING_ENABLE || item.getItemType() == IConfigWizardItem.EItemType.OPTION_CHECK) {
            item = this.processOptionDefault(item, defaultValueStr);
        } else if (item.getItemType() == IConfigWizardItem.EItemType.OPTION_SELECT) {
            item = this.processOptionSelectDefault(item, defaultValueStr);
        } else if (item.getItemType() == IConfigWizardItem.EItemType.OPTION_STRING) {
            item = this.processOptionStringDefault(item, defaultValueStr);
        }
        if (item == null) {
            return null;
        }
        this.getNextToken();
        return item;
    }

    private IConfigWizardItem processOptionDefault(IConfigWizardItem item, String tokenContent) {
        try {
            int value = Utils.parseDefaultInteger(tokenContent);
            item.setDefaultIntValue(value);
        }
        catch (IllegalArgumentException ex) {
            this.syntaxError(ex.getMessage());
            return null;
        }
        return item;
    }

    private IConfigWizardItem processOptionSelectDefault(IConfigWizardItem item, String tokenContent) {
        if (item.hasIdentifierItems()) {
            String key = tokenContent.trim();
            if (key.length() == 0) {
                this.syntaxError("missing default integer");
                return null;
            }
            if (key.contains(" ")) {
                this.syntaxError("option default must be a single identifier");
                return null;
            }
            if (key.contains("\"")) {
                this.syntaxError("option default must not be quoted");
                return null;
            }
            item.setDefaultStringValue(key);
        } else if (item.hasItems()) {
            try {
                int value = Utils.parseDefaultInteger(tokenContent);
                item.setDefaultIntValue(value);
            }
            catch (IllegalArgumentException ex) {
                this.syntaxError(ex.getMessage());
                return null;
            }
        }
        return item;
    }

    private IConfigWizardItem processOptionStringDefault(IConfigWizardItem item, String tokenContent) {
        String key = tokenContent.trim();
        if (key.length() == 0) {
            this.syntaxError("missing default string");
            return null;
        }
        if (!key.startsWith("\"")) {
            this.syntaxError("default string should start with \"");
            return null;
        }
        if (!(key = key.substring(1)).endsWith("\"")) {
            this.syntaxError("default string should end with \"");
            return null;
        }
        key = key.substring(0, key.length() - 1);
        item.setDefaultStringValue(key);
        return item;
    }

    private IConfigWizardItem processArrayDefault(IConfigWizardItem item, String tokenContent) {
        try {
            int[] values = Utils.parseIntegerArray(tokenContent, item.getArrayLength());
            item.setDefaultArrayValues(values);
        }
        catch (IllegalArgumentException ex) {
            this.syntaxError(ex.getMessage());
            return null;
        }
        return item;
    }

    private IConfigWizardItem parseFormat(IConfigWizardItem item) {
        String tokenContent = this.fScanner.getTokenContent(this.cToken);
        if (tokenContent != null) {
            if (tokenContent.matches("f\\.[dhob]")) {
                String formatStr = tokenContent.substring(tokenContent.length() - 1);
                item.setFormat(formatStr);
                this.getNextToken();
                return item;
            }
            this.syntaxError("Invalid format specification: <" + tokenContent + ">");
            return null;
        }
        return null;
    }

    private void validationErrors(List<String> list) {
        if (this.validationErrorListener != null) {
            StringBuilder sb = new StringBuilder(64 * list.size());
            sb.append("Encountered the following errors in annotations:\n");
            list.forEach(msg -> {
                StringBuilder stringBuilder2 = sb.append('\n').append((String)msg);
            });
            String message = sb.toString();
            this.validationErrorListener.error("Annotation Errors", message);
        }
    }

    private void syntaxError(String errorMessage) {
        this.fParsingErrorMessage = errorMessage;
        this.fParsingErrorOffset = this.fScanner.getTokenOffset();
        int line = this.fScanner.getCurrentLineNumber();
        if (this.syntaxErrorListener != null) {
            String msg = Messages.getString("ConfigWizardParser_SyntaxErrorAtLine") + (line + 1) + ": " + this.getParsingErrorMessage();
            this.syntaxErrorListener.error(Messages.getString("ConfigWizardParser_ErrorInConfigWizard"), msg);
        }
    }

    private IConfigWizardItem analyseCodeContent(IConfigWizardItem item) {
        int skip = item.getSkipNumber() + 1;
        int startLine = item.getStartLine() + skip;
        int startOffset = this.headerModel.getLineOffset(startLine);
        int endLine = item.getEndLine();
        int endOffset = this.headerModel.getLineOffset(endLine);
        if (startLine >= endLine) {
            this.syntaxError(Messages.getString("ConfigWizardParser_SkipTooManyLines"));
            return null;
        }
        String codeContent = this.headerModel.getDocumentContent(startOffset, endOffset - startOffset);
        String[] lines = codeContent.split("\\r?\\n");
        HashSet<Boolean> lineCommented = new HashSet<Boolean>();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().startsWith("//") || line.trim().startsWith("/*")) {
                lineCommented.add(true);
                if (line.trim().startsWith("//")) {
                    int moreOffset = line.indexOf("//");
                    int slashLength = 2;
                    while (line.length() > moreOffset + slashLength && line.charAt(moreOffset + slashLength) == '/') {
                        ++slashLength;
                    }
                    int slashBegin = startOffset + moreOffset;
                    this.headerModel.putComment(slashBegin, this.headerModel.getDocumentContent(slashBegin, slashLength));
                }
            } else {
                int spaceCount = 0;
                char[] cArray = line.toCharArray();
                int n3 = cArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    char c = cArray[n4];
                    if (c != ' ') break;
                    ++spaceCount;
                    ++n4;
                }
                this.headerModel.putComment(startOffset + spaceCount, "");
                lineCommented.add(false);
            }
            startOffset = this.headerModel.getLineOffset(++startLine);
            ++n2;
        }
        if (lineCommented.size() > 1) {
            item.setInconsistent(true);
        }
        if (lineCommented.contains(false)) {
            item.setValue(1L);
        } else {
            item.setValue(0L);
        }
        if (item.invertValue()) {
            item.setValue(1L - item.getValue());
        }
        return item;
    }

    private String getTokenTypeString(ConfigWizardScanner.ETokenType type) {
        switch (type) {
            case HEADING: {
                return "<h>";
            }
            case HEADING_ENABLE: {
                return "<e>";
            }
            case HEADING_ENABLE_END: {
                return "</e>";
            }
            case HEADING_END: {
                return "</h>";
            }
            case OPTION: {
                return "<o>";
            }
            case OPTION_CHECK: {
                return "<q>";
            }
            case OPTION_STRING: {
                return "<s>";
            }
            case NOTIFICATION: {
                return "<n>";
            }
            case TOOLTIP: {
                return "<i>";
            }
            case VALUE: {
                return "<\\d+=>";
            }
            case EOC: {
                return Messages.getString("ConfigWizardParser_EndOfConfiguration");
            }
            case BLOCK_COMMENT: {
                return Messages.getString("ConfigWizardParser_BlockComment");
            }
            case COMMENT: {
                return Messages.getString("ConfigWizardParser_Comment");
            }
            case DEFAULT: {
                return Messages.getString("ConfigWizardParser_Unknown");
            }
            case NUMBER: {
                return Messages.getString("ConfigWizardParser_Number");
            }
            case MACROVALUE: {
                return Messages.getString("ConfigWizardParser_MacroValue");
            }
        }
        return Messages.getString("ConfigWizardParser_Unknown");
    }

    private List<String> validate() {
        ArrayList<String> errors = new ArrayList<String>();
        this.validate(this.headerModel.getRootItem(), errors);
        return errors;
    }

    private void validate(IConfigWizardItem parent, List<String> errors) {
        if (parent.hasChildren()) {
            ArrayList<IConfigWizardItem> removeList = new ArrayList<IConfigWizardItem>();
            for (IConfigWizardItem child2 : parent.getChildren()) {
                String name = child2.getMacroName();
                if (name != null && this.headerModel.macroIsUnknownOrNoValue(name)) {
                    removeList.add(child2);
                    continue;
                }
                if (child2.getMinValue() <= child2.getMaxValue()) continue;
                errors.add("Range minimum exceeds range maximum");
            }
            removeList.forEach(child -> {
                ((ConfigWizardItem)parent).removeChild((IConfigWizardItem)child);
                errors.add("Annotation at line " + (child.getStartLine() + 1) + " uses undefined macro: " + child.getMacroName());
            });
            for (IConfigWizardItem child2 : parent.getChildren()) {
                this.validate(child2, errors);
            }
        }
    }

    private void setValuesAndStrings() {
        try {
            if (this.headerModel.getRootItem().hasChildren()) {
                for (IConfigWizardItem child : this.headerModel.getRootItem().getChildren()) {
                    this.headerModel.setValuesAndStrings(child);
                }
            }
        }
        catch (IHeaderContent.ContentException e) {
            this.syntaxError(e.getMessage());
        }
        catch (IllegalArgumentException ex) {
            this.syntaxError(ex.getMessage());
        }
    }

    private void getNextToken() {
        this.cToken = this.fScanner.nextToken();
        this.cType = this.fScanner.getTokenType(this.cToken);
        if (this.fScanner.getTokenType(this.cToken) == ConfigWizardScanner.ETokenType.EXT_START) {
            do {
                this.cToken = this.fScanner.nextToken();
                this.cType = this.fScanner.getTokenType(this.cToken);
            } while (this.fScanner.getTokenType(this.cToken) != ConfigWizardScanner.ETokenType.EXT_END);
            this.cToken = this.fScanner.nextToken();
            this.cType = this.fScanner.getTokenType(this.cToken);
        }
    }

    public boolean containWizard() {
        return this.fContainWizard;
    }

    public int getStartParseOffset() {
        return this.fStartParseOffset;
    }

    public int getEndParseOffset() {
        return this.fEndParseOffset;
    }

    public int getParsingErrorOffset() {
        return this.fParsingErrorOffset;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Start Parse Offset: " + this.fStartParseOffset + "\r\n");
        sb.append("End Parse Offset: " + this.fEndParseOffset + "\r\n");
        sb.append("Parsing Error: " + this.getParsingErrorMessage() + "\r\n");
        sb.append("Parsing Error offset: " + this.fParsingErrorOffset + "\r\n");
        sb.append("fContainWizard: " + this.fContainWizard + "\r\n");
        return sb.toString();
    }

    public static interface IErrorListener {
        public void error(String var1, String var2);
    }
}

