/*
 * Decompiled with CFR 0.152.
 */
package com.arm.cmsis.parser;

import com.silabs.jface.text.rules.ICharacterScanner;
import com.silabs.jface.text.rules.IRule;
import com.silabs.jface.text.rules.IToken;
import com.silabs.jface.text.rules.Token;

public class NumberRule
implements IRule {
    private IToken token;

    public NumberRule(IToken token) {
        this.token = token;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        scanner.unread();
        int prevCh = scanner.read();
        int startCh = scanner.read();
        int unreadCount = 1;
        if (this.isNumberStart(startCh)) {
            int ch = startCh;
            if (prevCh >= 65 && prevCh <= 90 || prevCh >= 97 && prevCh <= 122 || prevCh == 95) {
                while (this.isValidIdentifierChar((char)ch)) {
                    ch = scanner.read();
                }
                return Token.UNDEFINED;
            }
            if (startCh == 45) {
                ch = scanner.read();
                ++unreadCount;
            }
            if (ch == 48) {
                int xCh = scanner.read();
                if (xCh == 120 || xCh == 88 || xCh == 98 || xCh == 66) {
                    while (this.isHexNumberPart((char)(ch = scanner.read()))) {
                    }
                    scanner.unread();
                    if (!this.isValidIdentifierChar((char)ch) || ch == 85 || ch == 117 || ch == 76 || ch == 108) {
                        return this.token;
                    }
                    return Token.UNDEFINED;
                }
                scanner.unread();
            } else if (ch == 46) {
                ch = scanner.read();
                ++unreadCount;
            }
            if (Character.isDigit((char)ch)) {
                while (this.isHexNumberPart((char)(ch = scanner.read())) || ch == 46) {
                }
                if (!this.isNumberSuffix((char)ch)) {
                    scanner.unread();
                }
                return this.token;
            }
        }
        do {
            scanner.unread();
        } while (--unreadCount > 0);
        return Token.UNDEFINED;
    }

    private boolean isNumberStart(int ch) {
        return ch == 45 || Character.isDigit((char)ch);
    }

    private boolean isHexNumberPart(int ch) {
        return Character.isDigit((char)ch) || ch >= 97 && ch <= 102 || ch >= 65 && ch <= 70;
    }

    private boolean isNumberSuffix(char ch) {
        return ch == 'b' || ch == 'B' || ch == 'h' || ch == 'H' || ch == 'd' || ch == 'D' || ch == 'o' || ch == 'O' || ch == 'q' || ch == 'Q';
    }

    private boolean isValidIdentifierChar(char ch) {
        return ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || ch == '_';
    }
}

