/*
 * Decompiled with CFR 0.152.
 */
package com.arm.cmsis.utils;

import java.util.ArrayList;

public class Utils {
    private Utils() {
    }

    public static long modifyValue(long value, char op, long modifier, long max, long min) {
        long realValue = value;
        if (realValue > max) {
            realValue = max;
        }
        if (realValue < min) {
            realValue = min;
        }
        switch (op) {
            case '+': {
                realValue += modifier;
                break;
            }
            case '-': {
                realValue -= modifier;
                break;
            }
            case '*': {
                realValue *= modifier;
                break;
            }
            case '/': {
                realValue /= modifier;
                break;
            }
        }
        return realValue;
    }

    public static long modifyValueR(long value, char op, long modifier, long max, long min) {
        long realValue = value;
        switch (op) {
            case '+': {
                realValue -= modifier;
                break;
            }
            case '-': {
                realValue += modifier;
                break;
            }
            case '*': {
                realValue /= modifier;
                break;
            }
            case '/': {
                realValue *= modifier;
                break;
            }
        }
        if (realValue > max) {
            realValue = max;
        }
        if (realValue < min) {
            realValue = min;
        }
        return realValue;
    }

    public static int[] parseIntegerArray(String tokenContent, int expectedLength) {
        ArrayList<Integer> defaultValueList = new ArrayList<Integer>();
        if (!tokenContent.startsWith("{") || !tokenContent.endsWith("}")) {
            throw new IllegalArgumentException("Array default values should start with '{'");
        }
        if (!tokenContent.endsWith("}")) {
            throw new IllegalArgumentException("Array default values should end with '}'");
        }
        tokenContent = tokenContent.substring(1, tokenContent.length() - 1).trim();
        String[] values = tokenContent.split(",");
        int i = 0;
        while (i < values.length) {
            try {
                int val = Utils.parseDefaultInteger(values[i]);
                defaultValueList.add(val);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("Invalid integer at index " + i + ": " + values[i]);
            }
            ++i;
        }
        if (defaultValueList.size() != expectedLength) {
            throw new IllegalArgumentException("Expecting array of length: " + expectedLength);
        }
        int[] intValues = new int[expectedLength];
        int i2 = 0;
        while (i2 < expectedLength) {
            intValues[i2] = (Integer)defaultValueList.get(i2);
            ++i2;
        }
        return intValues;
    }

    public static int parseDefaultInteger(String str) throws IllegalArgumentException {
        if (str.trim().length() == 0) {
            throw new IllegalArgumentException("Missing default value");
        }
        String numStr = str.trim().toLowerCase();
        int radix = 10;
        if (numStr.startsWith("0x")) {
            radix = 16;
            numStr = numStr.substring(2);
        } else if (numStr.startsWith("0")) {
            radix = 8;
        }
        int number = 0;
        try {
            number = Integer.parseInt(numStr, radix);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Invalid integer: " + str, ex);
        }
        return number;
    }
}

