/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.templates;

import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.project.api.templates.ITemplateDescriptor;
import com.silabs.ss.framework.project.api.templates.TemplateProperties;
import com.silabs.ss.framework.project.api.toolchain.core.IToolchainDescriptor;
import com.silabs.ss.framework.project.api.toolchain.core.Toolchain;
import com.silabs.ss.framework.project.api.toolchain.core.ToolchainProperties;
import com.silabs.ss.framework.project.internal.templates.Activator;
import com.silabs.ss.platform.api.content.part.core.IPartDescriptor;
import com.silabs.ss.platform.api.content.part.core.PartCompatibility;
import com.silabs.ss.platform.api.descriptor.core.IDescriptor;
import com.silabs.ss.platform.api.descriptor.core.compatibility.Compatibility;
import com.silabs.ss.platform.api.descriptor.core.compatibility.ICompatibilityQuery;
import com.silabs.ss.platform.api.descriptor.core.property.CoreProperties;
import com.silabs.ss.platform.api.descriptor.core.registry.IRegistry;
import com.silabs.ss.platform.api.idemanager.core.IIDE;
import com.silabs.ss.platform.api.idemanager.core.IIDE2;
import java.net.URI;
import java.util.Collection;
import java.util.Locale;
import java.util.stream.Stream;
import org.eclipse.core.runtime.Path;

public class TemplateCompatUtils {
    public static boolean isCompatibleWithIDE(ITemplateDescriptor template, IIDE ide, IPartDescriptor ... parts) {
        block4: {
            boolean ideCompatible = TemplateCompatUtils.isTemplateIdeCompatible(template, ide);
            if (ideCompatible) break block4;
            return false;
        }
        try {
            if (!TemplateCompatUtils.checkPartsCompatibility(template, ide, parts)) {
                return false;
            }
        }
        catch (Exception e) {
            Activator.reporter.logException((Throwable)e);
        }
        return true;
    }

    public static boolean isCompatibleWithIde(ITemplateDescriptor template, IIDE ide, IToolchainDescriptor[] toolchains, IPartDescriptor ... parts) {
        try {
            boolean toolChainCompatibility = TemplateCompatUtils.checkToolChainCompatibility(template, toolchains);
            if (!toolChainCompatibility) {
                return false;
            }
        }
        catch (Exception e) {
            Activator.reporter.logException((Throwable)e);
        }
        return TemplateCompatUtils.isCompatibleWithIDE(template, ide, parts);
    }

    private static boolean isTemplateIdeCompatible(ITemplateDescriptor template, IIDE ide) {
        boolean ideCompatible = TemplateCompatUtils.checkIdeCompatibility(template, ide);
        if (ideCompatible) {
            return true;
        }
        boolean extensionCompatible = TemplateCompatUtils.checkExtensionCompatibility(template, ide);
        return extensionCompatible;
    }

    private static boolean checkExtensionCompatibility(ITemplateDescriptor template, IIDE ide) {
        String extension = "";
        URI rawInstallPath = (URI)template.getProperty(CoreProperties.INSTALLATION_PATH);
        if (rawInstallPath != null) {
            extension = new Path(rawInstallPath.toString()).getFileExtension();
        }
        String[] stringArray = ide.getProjectFileExtensions();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String projectExt = stringArray[n2];
            if (projectExt.equalsIgnoreCase(extension)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean checkIdeCompatibility(ITemplateDescriptor template, IIDE ide) {
        String projTypeIdeCompat;
        if (!"projectTemplate".equals(template.getNamespace()) && "simplicity-ide".equals(ide.getID())) {
            return true;
        }
        Collection compatIdes = (Collection)template.getProperty(TemplateProperties.IDE_COMPATIBILITY);
        if (compatIdes.isEmpty()) {
            return false;
        }
        String id = ide.getID().toLowerCase(Locale.ROOT);
        boolean compatible = TemplateCompatUtils.hasIdeCompatibility(compatIdes, id);
        if (!compatible && ide instanceof IIDE2 && TextUtils.hasContent((String)(projTypeIdeCompat = ((IIDE2)ide).getIdeCompatibilityId()))) {
            projTypeIdeCompat = projTypeIdeCompat.toLowerCase(Locale.ROOT);
            compatible = TemplateCompatUtils.hasIdeCompatibility(compatIdes, projTypeIdeCompat);
        }
        return compatible;
    }

    private static boolean hasIdeCompatibility(Collection<String> compatIdes, String id) {
        if (TextUtils.isEmpty((String)id)) {
            return false;
        }
        return compatIdes.stream().filter(TextUtils::hasContent).map(s -> s.toLowerCase(Locale.ROOT)).filter(c -> "all".equals(c) || ".*".equals(c) || id.startsWith(c + ":") || id.equals(c)).findAny().isPresent();
    }

    private static boolean checkPartsCompatibility(ITemplateDescriptor template, IIDE ide, IPartDescriptor ... parts) {
        ICompatibilityQuery ideCompat = PartCompatibility.fromGrammarString((String)ide.getPartCompatibility());
        boolean compatible = parts == null || parts.length == 0 || parts[0] == null ? ideCompat.isCompatibleWith(PartCompatibility.from((IDescriptor)template)) : ((Stream)Stream.of(parts).parallel()).anyMatch(arg_0 -> ((ICompatibilityQuery)ideCompat).isCompatibleWith(arg_0));
        return compatible;
    }

    private static boolean checkToolChainCompatibility(ITemplateDescriptor template, IToolchainDescriptor[] toolchains) {
        Collection compatToolchains = (Collection)template.getProperty(ToolchainProperties.TOOLCHAIN_COMPATIBILITY);
        if (compatToolchains != null && !compatToolchains.isEmpty() && toolchains.length > 0) {
            ICompatibilityQuery query = Compatibility.fromGrammar((IRegistry)Toolchain.manager(), (Collection)compatToolchains);
            IToolchainDescriptor[] iToolchainDescriptorArray = toolchains;
            int n = toolchains.length;
            int n2 = 0;
            while (n2 < n) {
                IToolchainDescriptor toolchain = iToolchainDescriptorArray[n2];
                if (query.isCompatibleWith((IDescriptor)toolchain)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        return true;
    }
}

