/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.templates.solution;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.project.api.templates.BaseTemplate;
import com.silabs.ss.framework.project.api.templates.ISolutionTemplateContext;
import com.silabs.ss.framework.project.api.templates.ITemplate;
import com.silabs.ss.framework.project.api.templates.ITemplateDescriptor;
import com.silabs.ss.framework.project.api.templates.Template;
import com.silabs.ss.framework.project.api.templates.TemplateProperties;
import com.silabs.ss.framework.project.api.templates.manager.ITemplateManager;
import com.silabs.ss.framework.project.api.templates.solution.ISolutionTemplate;
import com.silabs.ss.framework.project.api.templates.solution.SolutionTemplateProperties;
import com.silabs.ss.platform.api.descriptor.core.type.CoreTypes;
import com.silabs.ss.platform.api.sdk.core.SDKProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class SolutionTemplate
extends BaseTemplate
implements ISolutionTemplate {
    private ImmutableBiMap<String, String> cached_templateIds;
    private static final String LEGACY_DEBUG_GROUPS = "debugGroups";

    public SolutionTemplate(ITemplateDescriptor desc, String providingBundleId) throws CoreException {
        super(desc, providingBundleId);
    }

    @Override
    public String getDefaultName() {
        String name = super.getDefaultName();
        if (TextUtils.isEmpty((String)name)) {
            name = this.getName();
        }
        return name;
    }

    @Override
    public void executePreTemplateProcess(ISolutionTemplateContext context, IProgressMonitor monitor) throws CoreException {
    }

    @Override
    public Collection<String> getProjectTemplateIds() {
        return this.projectTemplateIdMap().values();
    }

    @Override
    public Collection<ITemplate> getProjectTemplates() {
        return this.getProjectTemplateIds().stream().map(arg_0 -> ((ITemplateManager)Template.manager()).find(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public Collection<String> getConfigurations() {
        return this.getConfigProjects().keySet();
    }

    @Override
    public Collection<String> getConfigurationTemplateIds(String configName) {
        return this.resolveRealIds(this.getConfigProjects().get(configName));
    }

    private Map<String, String> getConfigProjects() {
        Map configProjs = this.getProperty(SolutionTemplateProperties.CONFIGURATION_PROJECTS);
        if (configProjs.isEmpty()) {
            configProjs = (Map)this.getProperty(LEGACY_DEBUG_GROUPS);
        }
        return configProjs;
    }

    @Override
    public Collection<String> getLinkedProjects(String templateId) {
        String fakeId = (String)this.projectTemplateIdMap().inverse().get((Object)templateId);
        if (fakeId == null) {
            return Collections.emptyList();
        }
        return this.resolveRealIds(this.getProperty(SolutionTemplateProperties.LINKED_PROJECTS).get(fakeId));
    }

    @Override
    public String getInitiallyOpenedResource() {
        return this.resolveRealId(this.getProperty(TemplateProperties.INITIALLY_OPENED_RESOURCE));
    }

    @Override
    public Collection<String> getInitiallyRevealedFiles() {
        return this.getProperty(TemplateProperties.INITIALLY_REVEALED_FILES).stream().map(this::resolveRealId).collect(Collectors.toList());
    }

    private String resolveRealId(String path) {
        if (TextUtils.isEmpty((String)path)) {
            return path;
        }
        String[] rsrcPath = new String[]{path};
        this.projectTemplateIdMap().forEach((d, t) -> {
            String string = rsrcPath[0].replace((CharSequence)d, (CharSequence)t);
        });
        return rsrcPath[0];
    }

    private Collection<String> resolveRealIds(String templIds) {
        if (templIds == null) {
            return Collections.emptyList();
        }
        return ((Collection)CoreTypes.STRING_LIST.convert(templIds)).stream().map(arg_0 -> this.projectTemplateIdMap().get(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private BiMap<String, String> projectTemplateIdMap() {
        ImmutableBiMap<String, String> local_cached_templateIds = this.cached_templateIds;
        if (local_cached_templateIds == null) {
            ImmutableBiMap builtMap;
            Collection<String> templateIds = this.getProperty(SolutionTemplateProperties.SOLUTION_PROJECTS);
            HashMap templateMap = new HashMap(templateIds.size());
            ITemplateDescriptor[] iTemplateDescriptorArray = (ITemplateDescriptor[])Template.manager().getAllDescriptors();
            int n = iTemplateDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITemplateDescriptor tmpl = iTemplateDescriptorArray[n2];
                templateIds.stream().filter(tId -> this.checkTemplate((String)tId, tmpl)).forEach(tId -> this.checkTemplateId(templateMap, (String)tId, tmpl));
                ++n2;
            }
            if (templateIds.size() != templateMap.size()) {
                throw new IllegalStateException("Some templates were missing in the database for " + String.valueOf(templateIds) + " found " + String.valueOf(templateMap));
            }
            this.cached_templateIds = builtMap = (ImmutableBiMap)templateIds.stream().collect(ImmutableBiMap.toImmutableBiMap(tId -> tId, templateMap::get));
            return builtMap;
        }
        return local_cached_templateIds;
    }

    private boolean checkTemplate(String solutionTmplId, ITemplateDescriptor template) {
        String refId = (String)template.getProperty(SolutionTemplateProperties.SOLUTION_REFERENCE_ID);
        if (TextUtils.hasContent((String)refId)) {
            return solutionTmplId.equals(refId);
        }
        return template.getId().contains(solutionTmplId);
    }

    private void checkTemplateId(Map<String, String> templateMap, String templateId, ITemplateDescriptor templ) {
        if (templateMap.putIfAbsent(templateId, templ.getId()) == null) {
            return;
        }
        if (!Objects.equals(templ.getProperty(SDKProperties.CONTRIBUTING_SDK), this.getProperty(SDKProperties.CONTRIBUTING_SDK))) {
            return;
        }
        templateMap.put(templateId, templ.getId());
    }
}

