/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.support.mcu.api.part.core;

import com.silabs.java.utils.api.IActionParserListener;
import com.silabs.java.utils.api.ILineHandler;
import com.silabs.ss.platform.api.apack.core.execution.Executioner;
import com.silabs.ss.platform.api.apack.core.execution.IExecutionContext;
import com.silabs.ss.platform.api.apack.core.function.SimpleLineHandler;
import com.silabs.ss.platform.api.apack.core.model.AdapterPackFunctionFilter;
import com.silabs.ss.platform.api.apack.core.model.AdapterPackManager;
import com.silabs.ss.platform.api.apack.core.model.FunctionType;
import com.silabs.ss.platform.api.apack.core.model.IAdapterPackFunction;
import com.silabs.ss.platform.api.apack.core.model.IAdapterPackFunctionFilter;
import com.silabs.ss.platform.api.apack.core.model.IAdapterPackJobCreator;
import com.silabs.ss.platform.api.content.board.core.Board;
import com.silabs.ss.platform.api.content.board.core.IBoardDescriptor;
import com.silabs.ss.platform.api.content.part.core.IPartDescriptor;
import com.silabs.ss.platform.api.device.core.IDevice;
import com.silabs.ss.support.mcu.api.part.core.CommanderArgs;
import com.silabs.ss.support.mcu.api.part.core.MCUUtils;
import com.silabs.ss.support.mcu.internal.part.core.Activator;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class DetectPartJob
extends Job {
    public static final String JOB_NAME_SET = "Debug Mode OUT Detect Part";
    private static final Object apackFnDoneLock = new Object();
    private static final Object apackFnWaitLock = new Object();
    public static final String KEY_RECONFIGURING_DEBUG_CONNECTION = "Reconfiguring debug connection with detected device part number";
    public static final String KEY_PART_NUMBER = "Part Number";
    public static final String KEY_DIE_REVISION = "Die Revision";
    public static final String KEY_PRODUCTION_VER = "Production Ver";
    public static final String KEY_FLASH_SIZE = "Flash Size";
    public static final String KEY_SRAM_SIZE = "SRAM Size";
    public static final String KEY_UNIQUE_ID = "Unique ID";
    public static final String KEY_USER_DATA_PAGE = "User Data Page";
    public static final String KEY_MASS_ERASE = "Mass Erase";
    public static final String KEY_BOOTLOADER = "Bootloader";
    public static final String KEY_PIN_RESET = "Pin Reset";
    public static final boolean DEBUG = true;
    private IDevice device;
    private String debugInterface;
    private Boolean complete = false;
    private Boolean ignoreErrors = false;
    private final Map<String, String> deviceInfoMap;
    private IStatus jobStatus = null;
    private static final String[] DEVICE_TYPES = new String[]{"cortex-m3", "cortex-m33"};

    public DetectPartJob(IDevice device, String debugInterface) {
        super(JOB_NAME_SET);
        this.device = device;
        this.debugInterface = debugInterface;
        this.deviceInfoMap = new HashMap<String, String>();
        Activator.reporter.logInfo("Initialized the Detect Part Job with debug interface " + this.debugInterface + "!");
        Activator.reporter.logInfo("Passed in IDevice: " + this.device);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(final IProgressMonitor monitor) {
        Activator.reporter.logInfo("Running the Detect Part Job!");
        Class<DetectPartJob> clazz = DetectPartJob.class;
        synchronized (DetectPartJob.class) {
            DeviceInfoLineHandler lineHandler = this.createLineHandler(monitor);
            AdapterPackFunctionFilter filter = new AdapterPackFunctionFilter(this.device.hardware().targetPart());
            IAdapterPackFunction fn = this.getApackFunction((IAdapterPackFunctionFilter)filter);
            ExecutionContext execContext = new ExecutionContext(this.device);
            if (fn != null) {
                Object object;
                monitor.beginTask(this.getTaskName(), -1);
                try {
                    this.complete = false;
                    Executioner.instance().execute((IAdapterPackJobCreator)fn, (IExecutionContext)execContext, CommanderArgs.makeDetectPartArguments(this.device, this.debugInterface, DEVICE_TYPES[0]), (ILineHandler)lineHandler, (IActionParserListener)new IActionParserListener<IExecutionContext>(){

                        public void parseAction(IExecutionContext context, String token, Object ... values) {
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void endOfInput(IExecutionContext context) {
                            Object object = apackFnDoneLock;
                            synchronized (object) {
                                DetectPartJob.this.complete = true;
                            }
                            monitor.done();
                        }
                    });
                }
                catch (IOException | ParseException e) {
                    object = apackFnDoneLock;
                    synchronized (object) {
                        this.complete = true;
                    }
                    this.jobStatus = new Status(4, "com.silabs.ss.support.mcu.part.core", e.getMessage());
                }
                boolean done = false;
                object = apackFnDoneLock;
                synchronized (object) {
                    done = this.complete;
                }
                object = apackFnWaitLock;
                synchronized (object) {
                    while (!done) {
                        try {
                            apackFnWaitLock.wait(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.currentThread().interrupt();
                        }
                        Object object2 = apackFnDoneLock;
                        synchronized (object2) {
                            done = this.complete;
                        }
                    }
                }
                if (!this.ignoreErrors.booleanValue() && this.jobStatus == null && lineHandler.hasError()) {
                    Activator.reporter.logInfo("Detect Part Job ERRORED OUT with " + this.jobStatus);
                    this.jobStatus = new Status(4, "com.silabs.ss.support.mcu.part.core", lineHandler.getError());
                }
            }
            if (this.jobStatus == null) {
                this.jobStatus = Status.OK_STATUS;
            }
            if (this.deviceInfoMap.containsKey(KEY_PART_NUMBER) && !this.updateDeviceWithInfo(execContext)) {
                String errorMsg = "Detected Part " + this.deviceInfoMap.get(KEY_PART_NUMBER) + " is not in Studio's database of parts.";
                this.jobStatus = new Status(4, "com.silabs.ss.support.mcu.part.core", errorMsg);
            }
            Activator.reporter.logInfo("Detect Part Job Complete with " + this.jobStatus);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.jobStatus;
        }
    }

    private IAdapterPackFunction getApackFunction(IAdapterPackFunctionFilter filter) {
        FunctionType fcnType = CommanderArgs.DETECT_PART;
        List fns = AdapterPackManager.instance().findManagedFunctions(fcnType, filter);
        Activator.reporter.logInfo("Found Apack Function(s): " + fns);
        return fns.size() > 0 ? (IAdapterPackFunction)fns.get(0) : null;
    }

    private DeviceInfoLineHandler createLineHandler(IProgressMonitor monitor) {
        return new DeviceInfoLineHandler(CommanderArgs.DETECT_PART.id(), monitor);
    }

    private String getTaskName() {
        return "Detecting Part...";
    }

    public IStatus getJobStatus() {
        return this.jobStatus;
    }

    private boolean updateDeviceWithInfo(ExecutionContext execContext) {
        String partNum = this.deviceInfoMap.get(KEY_PART_NUMBER);
        IPartDescriptor[] targetParts = MCUUtils.findPartDescriptorInRegistryByPartNum(partNum);
        if (targetParts.length < 1) {
            return false;
        }
        execContext.device.hardware().addDetectedPart(targetParts[0]);
        MCUUtils.setTargetInterface(execContext.device, this.debugInterface.toLowerCase());
        execContext.device.settings().setTargetPart(targetParts[0]);
        IBoardDescriptor noneBrd = (IBoardDescriptor)Board.manager().findDescriptor("com.silabs.board.none:0.0.0");
        if (noneBrd != null) {
            IBoardDescriptor[] brds = new IBoardDescriptor[]{noneBrd};
            execContext.device.settings().setBoardOverrides(brds);
        }
        Activator.reporter.logInfo("Detected Target Parts size: " + targetParts.length);
        IPartDescriptor[] iPartDescriptorArray = targetParts;
        int n = targetParts.length;
        int n2 = 0;
        while (n2 < n) {
            IPartDescriptor targetPart = iPartDescriptorArray[n2];
            Activator.reporter.logInfo("ID: " + targetPart.getId() + ", NAME: " + targetPart.getName());
            ++n2;
        }
        return true;
    }

    private class DeviceInfoLineHandler
    extends SimpleLineHandler {
        protected static final String SETTING_DEBUG_INTERFACE_PATTERN = "Setting debug interface to";
        protected static final String TAG_INFO_START_PATTERN = "[INFO:";
        protected static final String TAG_INFO_END_PATTERN = "]";
        protected static final String TAG_INFO_SPLIT_PATTERN = ":";

        public DeviceInfoLineHandler(String name) {
            super(name, null);
        }

        public DeviceInfoLineHandler(String name, IProgressMonitor pm) {
            super(name, pm);
        }

        public void endOfInput(IExecutionContext context, IActionParserListener<IExecutionContext> listener) {
            super.endOfInput(context, listener);
        }

        public void handle(IExecutionContext context, String line, IActionParserListener<IExecutionContext> listener) {
            if (line != null) {
                if (line.contains(TAG_INFO_START_PATTERN)) {
                    String[] keyValPair;
                    String dataStr;
                    int startIndex = line.indexOf(TAG_INFO_START_PATTERN);
                    int endIndex = line.lastIndexOf(TAG_INFO_END_PATTERN);
                    if (startIndex != -1 && endIndex != -1 && startIndex < endIndex && (dataStr = line.substring(startIndex + TAG_INFO_START_PATTERN.length(), endIndex)) != null && (keyValPair = dataStr.split(TAG_INFO_SPLIT_PATTERN)).length == 2) {
                        String key = keyValPair[0].trim();
                        String value = keyValPair[1].trim();
                        DetectPartJob.this.deviceInfoMap.put(key, value);
                    }
                } else if (line.contains(SETTING_DEBUG_INTERFACE_PATTERN)) {
                    // empty if block
                }
                super.handle(context, line, listener);
            }
        }
    }

    protected class ExecutionContext
    implements IExecutionContext {
        protected IDevice device;

        public ExecutionContext(IDevice device) {
            this.device = device;
        }

        public String name() {
            return this.device == null ? "" : this.device.label();
        }
    }
}

