/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.support.mcu.api.part.core;

import com.silabs.java.utils.api.IActionParserListener;
import com.silabs.java.utils.api.ILineHandler;
import com.silabs.ss.platform.api.apack.core.execution.Executioner;
import com.silabs.ss.platform.api.apack.core.execution.IExecutionContext;
import com.silabs.ss.platform.api.apack.core.function.ProgressLineHandler;
import com.silabs.ss.platform.api.apack.core.model.AdapterPackManager;
import com.silabs.ss.platform.api.apack.core.model.IAdapterPackFunction;
import com.silabs.ss.platform.api.apack.core.model.IAdapterPackFunctionFilter;
import com.silabs.ss.platform.api.apack.core.model.IAdapterPackJobCreator;
import com.silabs.ss.platform.api.device.core.DeviceFilter;
import com.silabs.ss.platform.api.device.core.IDevice;
import com.silabs.ss.support.mcu.api.part.core.MCUUtils;
import com.silabs.ss.support.mcu.internal.part.core.Activator;
import com.silabs.ss.support.mcu.internal.part.core.FlashBytes;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class FlashBytesJob
extends Job {
    public static final String JOB_NAME = "Flashing bytes to Device";
    private IDevice device;
    private byte[] bytes;
    private long baseAddress = 0L;
    private boolean reset;
    private boolean run;
    private AtomicBoolean flashComplete = new AtomicBoolean(false);

    public FlashBytesJob(IDevice device, long addr, byte[] bytes, boolean reset, boolean run) {
        super(JOB_NAME);
        this.device = device;
        this.baseAddress = addr;
        this.bytes = bytes;
        this.reset = reset;
        this.run = run;
    }

    protected IStatus run(final IProgressMonitor monitor) {
        IStatus status = null;
        ProgressLineHandler lineHandler = new ProgressLineHandler(FlashBytes.TYPE.id(), monitor);
        DeviceFilter filter = new DeviceFilter(this.device);
        List fns = AdapterPackManager.instance().findManagedFunctions(FlashBytes.TYPE, (IAdapterPackFunctionFilter)filter);
        if (fns == null || fns.isEmpty()) {
            return Activator.reporter.newErrorStatus(MessageFormat.format("Fail to find utility (known as adapter pack internally) to download program to device ''{0}({1}'').", this.device.label(), this.device.hardware()));
        }
        assert (fns.size() == 1);
        IAdapterPackFunction fn = (IAdapterPackFunction)fns.get(0);
        monitor.beginTask("Flashing " + Arrays.toString(this.bytes) + " to " + Long.toHexString(this.baseAddress) + " on " + this.device.label(), 100);
        try {
            this.flashComplete.set(false);
            String partName = MCUUtils.getDebugPartName(this.device, false);
            Executioner.instance().execute((IAdapterPackJobCreator)fn, () -> this.device == null ? "" : this.device.label(), FlashBytes.makeArguments(this.device, partName, this.baseAddress, this.reset, this.run, this.bytes, this.bytes.length), (ILineHandler)lineHandler, (IActionParserListener)new IActionParserListener<IExecutionContext>(){

                public void parseAction(IExecutionContext context, String token, Object ... values) {
                }

                public void endOfInput(IExecutionContext context) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    FlashBytesJob.this.flashComplete.set(true);
                    monitor.worked(100);
                    monitor.done();
                }
            });
        }
        catch (Exception e) {
            this.flashComplete.set(true);
            status = Activator.reporter.newStatus(4, e.getMessage(), (Throwable)e);
        }
        while (!this.flashComplete.get()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        if (status == null && lineHandler.hasError()) {
            status = Activator.reporter.newStatus(4, lineHandler.getError(), null);
        }
        if (status == null) {
            status = Status.OK_STATUS;
        }
        return status;
    }
}

