/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.support.mcu.api.part.core;

import com.silabs.java.utils.api.IObjectConsumer;
import com.silabs.java.utils.preferences.PropertyReference;
import com.silabs.ss.platform.api.demos.core.DemoProperties;
import com.silabs.ss.platform.api.demos.core.DemoUtils;
import com.silabs.ss.platform.api.demos.core.IDemoDescriptor;
import com.silabs.ss.platform.api.device.core.IDevice;
import com.silabs.ss.support.mcu.api.part.core.UploadArgsFactory;
import com.silabs.ss.support.mcu.api.part.core.UploadJob;
import com.silabs.ss.support.mcu.internal.part.core.Activator;
import com.silabs.ss.support.mcu.internal.part.core.WriteFirmwareJob;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

public class MCUDemoUtils {
    public static Job createFlashDemoJob(IDemoDescriptor demo, IDevice device, boolean resume) throws CoreException {
        return MCUDemoUtils.createFlashJob(demo, device, resume, true, null);
    }

    public static void flashAndRunDemo(IDemoDescriptor demo, IDevice device) throws CoreException {
        MCUDemoUtils.flashAndRunDemo(demo, device, null);
    }

    public static void flashAndRunDemo(IDemoDescriptor demo, IDevice device, IObjectConsumer<IStatus> completionListener) throws CoreException {
        Job flashJob = MCUDemoUtils.createFlashJob(demo, device, true, true, completionListener);
        flashJob.setUser(true);
        flashJob.schedule();
    }

    public static void flashAndRunDemo(IDemoDescriptor demo, IDevice device, boolean useBootloader) throws CoreException {
        MCUDemoUtils.flashAndRunDemo(demo, device, useBootloader, null);
    }

    public static void flashAndRunDemo(IDemoDescriptor demo, IDevice device, boolean useBootloader, IObjectConsumer<IStatus> completionListener) throws CoreException {
        Job flashJob = MCUDemoUtils.createFlashJob(demo, device, true, useBootloader, completionListener);
        flashJob.setUser(true);
        flashJob.schedule();
    }

    private static IPath getFirmwareImage(IDemoDescriptor demo) throws IOException {
        return DemoUtils.getDemoFirmware((IDemoDescriptor)demo);
    }

    private static String getDemoFirmwareVersion(IDemoDescriptor demo) {
        return DemoUtils.getDemoFirmwareVersion((IDemoDescriptor)demo);
    }

    private static Job createFlashJob(IDemoDescriptor demo, IDevice device, boolean resume, boolean useBootloader, IObjectConsumer<IStatus> completionListener) throws CoreException {
        IPath fwPath = null;
        Job uploadDemoJob = MCUDemoUtils.createUploadJob(demo, device, resume, useBootloader, completionListener);
        WriteFirmwareJob uploadFirmwareJob = null;
        try {
            fwPath = MCUDemoUtils.getFirmwareImage(demo);
        }
        catch (IOException e) {
            Activator.reporter.logException((Throwable)e);
        }
        if (fwPath != null) {
            uploadFirmwareJob = new WriteFirmwareJob(device, fwPath, MCUDemoUtils.getDemoFirmwareVersion(demo), true, uploadDemoJob);
        }
        return uploadFirmwareJob == null ? uploadDemoJob : uploadFirmwareJob;
    }

    private static Job createUploadJob(IDemoDescriptor demo, IDevice device, boolean resume, boolean useBootloader, final IObjectConsumer<IStatus> completionListener) throws CoreException {
        UploadArgsFactory factory = UploadArgsFactory.createFactory(device).setReset(true).setRun(resume).setExtFlash(false);
        try {
            factory.setImage(demo.getImageFilePath());
            if (useBootloader) {
                factory.setBootImage(DemoUtils.getDemoBootloader((IDemoDescriptor)demo)).setSigningKey(DemoUtils.getPathProperty((IDemoDescriptor)demo, (PropertyReference)DemoProperties.SIGNING_KEY)).setEncryptionKey(DemoUtils.getPathProperty((IDemoDescriptor)demo, (PropertyReference)DemoProperties.ENCRYPTION_KEY));
            }
        }
        catch (IOException e) {
            throw Activator.reporter.newCoreException("Could not find the demo binaries", (Throwable)e);
        }
        UploadJob job = new UploadJob(factory);
        if (completionListener != null) {
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    completionListener.accept((Object)event.getResult());
                }
            });
        }
        return job;
    }
}

