/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.support.mcu.api.part.core;

import com.silabs.java.utils.api.IActionParserListener;
import com.silabs.java.utils.api.ILineHandler;
import com.silabs.ss.platform.api.apack.core.execution.Executioner;
import com.silabs.ss.platform.api.apack.core.execution.IExecutionContext;
import com.silabs.ss.platform.api.apack.core.execution.TimedApackJob;
import com.silabs.ss.platform.api.apack.core.function.SimpleLineHandler;
import com.silabs.ss.platform.api.apack.core.model.AdapterPackManager;
import com.silabs.ss.platform.api.apack.core.model.IAdapterPackFunction;
import com.silabs.ss.platform.api.apack.core.model.IAdapterPackFunctionFilter;
import com.silabs.ss.platform.api.apack.core.model.IAdapterPackJobCreator;
import com.silabs.ss.platform.api.device.core.DeviceFilter;
import com.silabs.ss.platform.api.device.core.IDevice;
import com.silabs.ss.support.mcu.api.part.core.IExecutionCompleteCallback;
import com.silabs.ss.support.mcu.api.part.core.ResetJobArgs;
import com.silabs.ss.support.mcu.internal.part.core.Activator;
import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ResetJob
extends TimedApackJob {
    public static final String JOB_NAME = "Reset Target Device";
    private final IDevice device;
    private final IExecutionCompleteCallback completionListener;
    private AtomicBoolean resetComplete = new AtomicBoolean(false);

    public ResetJob(IDevice device, IExecutionCompleteCallback completionListener) {
        super(JOB_NAME, 8000L);
        this.device = device;
        this.completionListener = completionListener;
    }

    protected IStatus run(final IProgressMonitor monitor) {
        IStatus status = null;
        ResetResposeLineHandler lineHandler = new ResetResposeLineHandler(ResetJobArgs.TYPE.id(), monitor);
        DeviceFilter filter = new DeviceFilter(this.device);
        List fns = AdapterPackManager.instance().findManagedFunctions(ResetJobArgs.TYPE, (IAdapterPackFunctionFilter)filter);
        if (fns == null || fns.isEmpty()) {
            return Activator.reporter.newErrorStatus(MessageFormat.format("Fail to find utility (known as adapter pack internally) to reset device ''{0}({1}'').", this.device.label(), this.device.hardware()));
        }
        assert (fns.size() == 1);
        IAdapterPackFunction fn = (IAdapterPackFunction)fns.get(0);
        monitor.beginTask("Resetting " + this.device.label(), 100);
        try {
            this.resetComplete.set(false);
            this.updateLastActivityTime();
            this.setAdapterPackJob(Executioner.instance().execute((IAdapterPackJobCreator)fn, () -> this.device == null ? "" : this.device.label(), ResetJobArgs.makeArguments(this.device), (ILineHandler)lineHandler, (IActionParserListener)new IActionParserListener<IExecutionContext>(){

                public void parseAction(IExecutionContext context, String token, Object ... values) {
                }

                public void endOfInput(IExecutionContext context) {
                    ResetJob.this.updateLastActivityTime();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    ResetJob.this.resetComplete.set(true);
                    monitor.worked(100);
                    monitor.done();
                }
            }));
        }
        catch (Exception e) {
            this.resetComplete.set(true);
            status = Activator.reporter.newStatus(4, e.getMessage(), (Throwable)e);
        }
        while (!this.resetComplete.get()) {
            try {
                Thread.sleep(100L);
                if (!this.shouldTimeout()) continue;
                status = new Status(4, "com.silabs.ss.support.mcu.part.core", "reset timed out after " + this.getTimeout() + "ms");
                this.kill();
                break;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        if (status == null && lineHandler.hasError()) {
            String errStr = lineHandler.getError();
            if (lineHandler.hasWarning()) {
                errStr = String.valueOf(errStr) + " ";
                errStr = String.valueOf(errStr) + lineHandler.getWarning();
            }
            status = Activator.reporter.newStatus(4, errStr, null);
        }
        if (status == null) {
            status = Status.OK_STATUS;
        }
        if (this.completionListener != null) {
            this.completionListener.executionComplete(status);
        }
        return status;
    }

    protected class ExecutionContext
    implements IExecutionContext {
        protected IDevice device;

        public ExecutionContext(IDevice device) {
            this.device = device;
        }

        public String name() {
            return this.device == null ? "" : this.device.label();
        }
    }

    private static class ResetResposeLineHandler
    extends SimpleLineHandler {
        public ResetResposeLineHandler(String name, IProgressMonitor pm) {
            super(name, pm);
        }
    }
}

