/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.support.mcu.api.part.core;

import com.silabs.java.utils.TextUtils;
import com.silabs.ss.platform.api.apack.core.model.FunctionType;
import com.silabs.ss.platform.api.content.part.core.IPartDescriptor;
import com.silabs.ss.platform.api.device.core.DeviceManager;
import com.silabs.ss.platform.api.device.core.IDevice;
import com.silabs.ss.support.mcu.api.part.core.MCUPartProperties;
import com.silabs.ss.support.mcu.api.part.core.MCUUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IPath;

public class UploadArgsFactory {
    public static final FunctionType TYPE = FunctionType.make((String)"upload");
    public static final String ARG_SERIAL_NUMBER = "sn";
    public static final String ARG_ADDRESS = "addr";
    public static final String ARG_TIF = "tif";
    public static final String ARG_FILE = "file";
    public static final String ARG_RESET = "reset";
    public static final String ARG_BASE_ADDR = "start";
    public static final String ARG_BASE_ADDR_HEX = "starthex";
    public static final String ARG_RUN = "run";
    public static final String ARG_EXTFLASH = "external";
    public static final String ARG_PART = "part";
    public static final String ARG_ERASE_MODE = "erasemode";
    public static final String ARG_BOOT_IMAGE = "bootImage";
    private static final String ARG_SIGNING_KEY = "signingKey";
    private static final String ARG_ENCRYPTION_KEY = "encryptionKey";
    public static final String ARG_ERASE_MODE_DEFAULT = "full";
    public static final String ARG_FILES = "files";
    private Map<String, Object> args = new HashMap<String, Object>();
    private IDevice device;
    private boolean doSecureUnlock = true;

    public static UploadArgsFactory createFactory(IDevice device) {
        UploadArgsFactory factory = new UploadArgsFactory();
        factory.device = device;
        IPartDescriptor targetPart = MCUUtils.getTargetPartFromDevice(device);
        if (device.hardware().adapterIPAddress() != null) {
            factory.args.put(ARG_ADDRESS, device.hardware().adapterIPAddress());
        } else {
            factory.args.put(ARG_SERIAL_NUMBER, device.hardware().adapterSerialNumber());
        }
        factory.args.put(ARG_TIF, MCUUtils.getTargetInterface(device));
        DeviceManager.applyConnectionOptions((IDevice)device, factory.args);
        boolean partNameIsSet = false;
        if (targetPart != null && !TextUtils.isEmpty((String)((String)targetPart.getProperty(MCUPartProperties.FLASH_PART_NAME)))) {
            factory.setPartName((String)targetPart.getProperty(MCUPartProperties.FLASH_PART_NAME));
            partNameIsSet = true;
        }
        if (!partNameIsSet) {
            factory.setPartName(MCUUtils.getDebugPartName(device, false));
            partNameIsSet = true;
        }
        return factory;
    }

    public UploadArgsFactory setImage(IPath image) {
        return this.setImages(image);
    }

    public UploadArgsFactory setImages(IPath ... images) {
        if (images.length > 0) {
            this.args.put(ARG_FILE, images[0].toOSString());
        }
        String imagePaths = Arrays.stream(images).skip(1L).map(p -> "\"" + p.toOSString() + "\"").collect(Collectors.joining(" "));
        this.args.put(ARG_FILES, imagePaths);
        return this;
    }

    public UploadArgsFactory setEraseMode(String eraseMode) {
        if (eraseMode != null && eraseMode.length() > 0) {
            this.args.put(ARG_ERASE_MODE, eraseMode);
        }
        return this;
    }

    public UploadArgsFactory setBaseAddress(long baseAddress) {
        this.args.put(ARG_BASE_ADDR, baseAddress);
        this.args.put(ARG_BASE_ADDR_HEX, "0x" + Long.toHexString(baseAddress));
        return this;
    }

    public UploadArgsFactory setReset(boolean reset) {
        this.args.put(ARG_RESET, reset);
        return this;
    }

    public UploadArgsFactory setRun(boolean run) {
        this.args.put(ARG_RUN, run);
        return this;
    }

    public UploadArgsFactory setExtFlash(boolean extFlash) {
        this.args.put(ARG_EXTFLASH, extFlash);
        return this;
    }

    public UploadArgsFactory setPartName(String partName) {
        this.args.put(ARG_PART, partName);
        return this;
    }

    public UploadArgsFactory setBootImage(IPath bootImage) {
        if (bootImage == null) {
            this.args.remove(ARG_BOOT_IMAGE);
        } else {
            this.args.put(ARG_BOOT_IMAGE, bootImage.toOSString());
        }
        return this;
    }

    public UploadArgsFactory setSigningKey(IPath signingKey) {
        if (signingKey == null) {
            this.args.remove(ARG_SIGNING_KEY);
        } else {
            this.args.put(ARG_SIGNING_KEY, signingKey.toOSString());
        }
        return this;
    }

    public UploadArgsFactory setEncryptionKey(IPath encryptionKey) {
        if (encryptionKey == null) {
            this.args.remove(ARG_ENCRYPTION_KEY);
        } else {
            this.args.put(ARG_ENCRYPTION_KEY, encryptionKey.toOSString());
        }
        return this;
    }

    public UploadArgsFactory setSecureUnlockEnabled(boolean enabled) {
        this.doSecureUnlock = enabled;
        return this;
    }

    public IDevice getDevice() {
        return this.device;
    }

    public Map<String, Object> getArgs() {
        return this.args;
    }

    public String getImage() {
        return (String)this.getArgs().get(ARG_FILE);
    }

    public boolean isSecureUnlockEnabled() {
        return this.doSecureUnlock;
    }
}

