/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.support.mcu.api.part.core.secure;

import com.silabs.ss.platform.api.content.part.core.IPartDescriptor;
import com.silabs.ss.platform.api.descriptor.core.IDescribable;
import com.silabs.ss.platform.api.device.core.DeviceHardware;
import com.silabs.ss.platform.api.device.core.DeviceManager;
import com.silabs.ss.platform.api.device.core.IDevice;
import com.silabs.ss.platform.api.device.core.IDeviceManagerListener;
import com.silabs.ss.support.mcu.api.cryptoprofile.core.CryptoProfile;
import com.silabs.ss.support.mcu.api.cryptoprofile.core.CryptoProfileManager;
import com.silabs.ss.support.mcu.api.cryptoprofile.core.CryptoProfileSelectorHelper;
import com.silabs.ss.support.mcu.api.part.core.secure.ISecurePart;
import com.silabs.ss.support.mcu.internal.api.part.core.MCUDeviceSettingExtension;
import com.silabs.ss.support.mcu.internal.part.core.Activator;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class SecurePartUtils {
    private static Map<IDevice, CryptoProfile> profileMap = new HashMap<IDevice, CryptoProfile>();
    private static Map<IDevice, SecurePartCache> sSecureDeviceMap = new HashMap<IDevice, SecurePartCache>();
    private static Map<IPartDescriptor, SecurePartCache> sSecurePartMap = new HashMap<IPartDescriptor, SecurePartCache>();
    private static IDeviceManagerListener deviceListener = null;

    public static boolean isSecureDevice(IDevice device) {
        return SecurePartUtils.getSecurePartExt(device) != null;
    }

    public static boolean isSecurePart(IPartDescriptor part) {
        return SecurePartUtils.getSecurePartExt(part) != null;
    }

    public static boolean isLockStatusKnown(IDevice device) throws CoreException {
        ISecurePart secPart = SecurePartUtils.getSecurePartExt(device);
        if (secPart == null) {
            return true;
        }
        return secPart.isLockStatusKnown(device);
    }

    public static boolean allowBackgroundCommands(IDevice device) {
        ISecurePart secPart = SecurePartUtils.getSecurePartExt(device);
        if (secPart == null) {
            return true;
        }
        return secPart.allowBackgroundCommands(device);
    }

    public static boolean isLocked(IDevice device) throws CoreException {
        ISecurePart secPart = SecurePartUtils.getSecurePartExt(device);
        if (secPart == null) {
            return false;
        }
        return secPart.isLocked(device);
    }

    public static void lock(IDevice device) throws CoreException {
        ISecurePart secPart = SecurePartUtils.getSecurePartExt(device);
        if (secPart == null) {
            throw new CoreException((IStatus)new Status(4, "com.silabs.ss.support.mcu.part.core", "No secure device extension available for this device"));
        }
        secPart.lock(device);
    }

    public static void unlock(IDevice device) throws CoreException {
        if (!SecurePartUtils.isLocked(device)) {
            return;
        }
        CryptoProfile profile = SecurePartUtils.getCryptoProfile(device);
        if (SecurePartUtils.profileIsNone(device)) {
            return;
        }
        ISecurePart secPart = SecurePartUtils.getSecurePartExt(device);
        if (secPart == null) {
            throw new CoreException((IStatus)new Status(4, "com.silabs.ss.support.mcu.part.core", "No secure device extension available for this device"));
        }
        secPart.unlock(device, profile);
    }

    public static boolean profileIsNone(IDevice device) {
        return SecurePartUtils.profileIsNone(SecurePartUtils.getCryptoProfile(device));
    }

    public static boolean profileIsNone(CryptoProfile profile) {
        return profile != null && profile.getId().equals("CryptoProfileManager.None");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CryptoProfile getCryptoProfile(IDevice device) {
        Map<IDevice, CryptoProfile> map = profileMap;
        synchronized (map) {
            String savedId;
            CryptoProfile profile = profileMap.get(device);
            if (profile == null && (savedId = ((MCUDeviceSettingExtension)device.settings().getExtension(MCUDeviceSettingExtension.class)).getCryptoProfileID()) != null) {
                CryptoProfile[] cryptoProfileArray = CryptoProfileManager.instance().getProfiles();
                int n = cryptoProfileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    CryptoProfile cp = cryptoProfileArray[n2];
                    if (cp.getId().compareTo(savedId) == 0) {
                        profile = cp;
                        break;
                    }
                    ++n2;
                }
            }
            return profile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCryptoProfile(IDevice device, CryptoProfile profile) {
        if (device == null) {
            return;
        }
        Map<IDevice, CryptoProfile> map = profileMap;
        synchronized (map) {
            if (profile == null) {
                profileMap.remove(device);
            } else {
                profileMap.put(device, profile);
            }
        }
        ((MCUDeviceSettingExtension)device.settings().getExtension(MCUDeviceSettingExtension.class)).setCryptoProfileID(profile == null ? null : profile.getId());
        try {
            DeviceManager.instance().saveDeviceSetting(device.hardware(), device.settings());
        }
        catch (IOException e) {
            Activator.reporter.logError("Failed to save crypto profile", (Throwable)e);
        }
    }

    public static CryptoProfile ensureCryptoProfile(IDevice device) {
        try {
            if (SecurePartUtils.isLockStatusKnown(device) && !SecurePartUtils.isLocked(device)) {
                return null;
            }
        }
        catch (CoreException e) {
            Activator.reporter.logError("Error reading lock status.", (Throwable)e);
            e.printStackTrace();
            return null;
        }
        CryptoProfile profile = SecurePartUtils.getCryptoProfile(device);
        if (profile == null) {
            profile = SecurePartUtils.selectCryptoProfile(device, null, true);
        }
        return profile;
    }

    public static CryptoProfile selectCryptoProfile(IDevice device, CryptoProfile defaultProfile, boolean saveSelection) {
        return SecurePartUtils.selectCryptoProfile(device, defaultProfile, saveSelection, -1, -1);
    }

    public static CryptoProfile selectCryptoProfile(IDevice device, CryptoProfile defaultProfile, boolean saveSelection, int posX, int posY) {
        CryptoProfile newProfile = CryptoProfileSelectorHelper.select((IDevice)device, (CryptoProfile)defaultProfile, (int)posX, (int)posY);
        if (saveSelection && newProfile != null) {
            SecurePartUtils.setCryptoProfile(device, newProfile);
        }
        return newProfile;
    }

    private static ISecurePart getSecurePartExt(IPartDescriptor part) {
        if (part == null) {
            return null;
        }
        SecurePartCache securePartCache = SecurePartUtils.getSecurePart(part);
        if (securePartCache != null) {
            return securePartCache.getSecurePart();
        }
        ISecurePart secPart = (ISecurePart)Platform.getAdapterManager().loadAdapter((Object)part, ISecurePart.class.getName());
        SecurePartUtils.setSecurePart(part, secPart);
        return secPart;
    }

    private static ISecurePart getSecurePartExt(IDevice device) {
        if (device == null) {
            return null;
        }
        SecurePartUtils.ensureDeviceListener();
        SecurePartCache securePartCache = SecurePartUtils.getSecurePart(device);
        if (securePartCache != null) {
            return securePartCache.getSecurePart();
        }
        ISecurePart secPart = (ISecurePart)Platform.getAdapterManager().loadAdapter((Object)device, ISecurePart.class.getName());
        SecurePartUtils.setSecurePart(device, secPart);
        return secPart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SecurePartCache getSecurePart(IPartDescriptor part) {
        Map<IPartDescriptor, SecurePartCache> map = sSecurePartMap;
        synchronized (map) {
            return sSecurePartMap.get(part);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SecurePartCache getSecurePart(IDevice device) {
        Map<IDevice, SecurePartCache> map = sSecureDeviceMap;
        synchronized (map) {
            return sSecureDeviceMap.get(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setSecurePart(IPartDescriptor part, ISecurePart secPart) {
        Map<IPartDescriptor, SecurePartCache> map = sSecurePartMap;
        synchronized (map) {
            sSecurePartMap.put(part, new SecurePartCache(secPart, part.getId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setSecurePart(IDevice device, ISecurePart secPart) {
        if (device == null || device.hardware() == null || device.hardware().parts(true) == null) {
            return;
        }
        Map<IDevice, SecurePartCache> map = sSecureDeviceMap;
        synchronized (map) {
            sSecureDeviceMap.put(device, new SecurePartCache(secPart, device.hardware().toString(), (String[])Arrays.stream(device.hardware().parts(true)).map(IDescribable::getId).toArray(String[]::new)));
        }
    }

    private static void ensureDeviceListener() {
        if (deviceListener != null) {
            return;
        }
        deviceListener = new IDeviceManagerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void deviceRemoved(IDevice device) {
                Map<IDevice, SecurePartCache> map = sSecureDeviceMap;
                synchronized (map) {
                    sSecureDeviceMap.remove(device);
                }
            }

            public void deviceAdded(IDevice device) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void deviceUpdate(IDevice device) {
                if (device == null || device.hardware() == null) {
                    return;
                }
                Map<IDevice, SecurePartCache> map = sSecureDeviceMap;
                synchronized (map) {
                    SecurePartCache cache = sSecureDeviceMap.get(device);
                    if (cache != null && !cache.isSame(device.hardware())) {
                        sSecureDeviceMap.remove(device);
                    }
                }
            }

            public void deviceSelected(IDevice device, String selectorID) {
            }

            public void deviceDeselected(IDevice device, String selectorID) {
            }
        };
        DeviceManager.instance().addDeviceManagerListener(deviceListener);
    }

    private static class SecurePartCache {
        private final ISecurePart secPartIntf;
        private final String hardwareId;
        private final String[] partIds;

        SecurePartCache(ISecurePart secPartIntf, String ID2) {
            this(secPartIntf, ID2, new String[]{ID2});
        }

        SecurePartCache(ISecurePart secPartIntf, String ID2, String[] partIds) {
            this.secPartIntf = secPartIntf;
            this.hardwareId = ID2;
            this.partIds = partIds;
        }

        ISecurePart getSecurePart() {
            return this.secPartIntf;
        }

        boolean isSame(DeviceHardware hardware) {
            return hardware.toString().equals(this.hardwareId) && Arrays.equals(Arrays.stream(hardware.parts(true)).map(IDescribable::getId).toArray(String[]::new), this.partIds);
        }
    }
}

