/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.support.mcu.api.part.core.secure;

import com.silabs.ss.platform.api.device.core.IDevice;
import com.silabs.ss.platform.api.device.core.IDeviceValidator;
import com.silabs.ss.support.mcu.api.cryptoprofile.core.CryptoProfile;
import com.silabs.ss.support.mcu.api.part.core.secure.LaunchSecureDeviceTool;
import com.silabs.ss.support.mcu.api.part.core.secure.QueryDeviceLockStatus;
import com.silabs.ss.support.mcu.api.part.core.secure.SecurePartUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class SecurePartValidator
implements IDeviceValidator {
    public IStatus accept(IDevice device) {
        if (SecurePartUtils.isSecureDevice(device)) {
            try {
                if (!SecurePartUtils.isLockStatusKnown(device)) {
                    return new QueryDeviceLockStatus(4, "com.silabs.ss.support.mcu.part.core", device, "Lock status unknown. <a>Click to Query Lock Status</a>.  WARNING: This action may reset your part.");
                }
                if (SecurePartUtils.isLocked(device)) {
                    CryptoProfile cryptoProfile = SecurePartUtils.getCryptoProfile(device);
                    if (cryptoProfile == null) {
                        return new LaunchSecureDeviceTool(4, "com.silabs.ss.support.mcu.part.core", device, "Secure device with no Crypto Profile. <a>Manage Crypto Profiles.</a>");
                    }
                    return new LaunchSecureDeviceTool(1, "com.silabs.ss.support.mcu.part.core", device, "Secure device using " + cryptoProfile.getDisplayName() + " profile. <a>Manage Crypto Profiles.</a>");
                }
            }
            catch (CoreException coreException) {
                return new Status(1, "com.silabs.ss.support.mcu.part.core", "Failed to read lock status.");
            }
        }
        return Status.OK_STATUS;
    }
}

