/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.support.mcu.api.part.core.si32;

import com.silabs.ss.platform.api.content.part.core.IPart;
import com.silabs.ss.platform.api.descriptor.core.IDescriptor;
import com.silabs.ss.support.mcu.api.part.core.IMCUPart;
import com.silabs.ss.support.mcu.api.part.core.MCUPart;
import com.silabs.ss.support.mcu.api.part.core.si32.EARMCore;
import com.silabs.ss.support.mcu.api.part.core.si32.EFPUIdentifier;
import com.silabs.ss.support.mcu.api.part.core.si32.Si32PartProperties;
import com.silabs.ss.support.mcu.internal.part.core.Activator;
import org.eclipse.core.runtime.CoreException;

public class Si32PartUtils {
    public static final String SI32_PART_FAMILY = "mcu.arm";
    public static final String ARCHITECTURE_FAMILY_ARM = "ARM";

    public static boolean isARMPart(IPart part) {
        return (part instanceof IMCUPart || Si32PartUtils.isARMPartId(part.getId())) && ARCHITECTURE_FAMILY_ARM.equals(MCUPart.getArchitectureFamily((IDescriptor)part));
    }

    public static boolean isARMPartId(String partId) {
        return partId != null && partId.startsWith(SI32_PART_FAMILY);
    }

    public static EARMCore getARMCore(IPart part) throws CoreException {
        if (part == null) {
            throw Activator.reporter.newCoreException("null part passed to getARMCore()");
        }
        if (!Si32PartUtils.isARMPart(part)) {
            return null;
        }
        return (EARMCore)((Object)part.getProperty(Si32PartProperties.ARM_CORE_PROPERTY));
    }

    public static EFPUIdentifier getFPU(IPart part) throws CoreException {
        if (part == null) {
            throw Activator.reporter.newCoreException("null part passed to getFPU()");
        }
        if (!Si32PartUtils.isARMPart(part)) {
            return null;
        }
        return (EFPUIdentifier)((Object)part.getProperty(Si32PartProperties.FPU_PROPERTY));
    }
}

