/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.support.mcu.internal.api.part.core;

import com.silabs.ss.platform.api.content.board.core.IBoardDescriptor;
import com.silabs.ss.platform.api.device.core.IDevice;
import com.silabs.ss.platform.api.device.core.IDeviceSettingExtension;
import com.silabs.ss.support.mcu.api.cryptoprofile.core.CryptoPreference;
import com.silabs.ss.support.mcu.internal.api.part.core.TargetInterfaceType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class MCUDeviceSettingExtension
implements IDeviceSettingExtension {
    private static final String TARGET_INTERFACE_ID = "tifId";
    private static final String CRYPTO_PROFILE_ID = "cryptoId";
    private static final String SEPARATOR = ":";
    private String detectedTargetInterface;
    private String targetInterface;
    private String cryptoProfileID;

    public String getTargetInterface() {
        return this.targetInterface;
    }

    public void setTargetInterface(String targetInterface) {
        this.targetInterface = targetInterface;
    }

    public String getCryptoProfileID() {
        return this.cryptoProfileID;
    }

    public void setCryptoProfileID(String id) {
        this.cryptoProfileID = id;
    }

    public void init(IDevice device) {
        String[] tids;
        IBoardDescriptor[] iBoardDescriptorArray = device.hardware().boards(false);
        int n = iBoardDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBoardDescriptor board = iBoardDescriptorArray[n2];
            String[] tids2 = TargetInterfaceType.getSupportedTargetInterfaces(board);
            if (tids2 != null && tids2.length == 1) {
                this.detectedTargetInterface = tids2[0];
                break;
            }
            ++n2;
        }
        if (this.detectedTargetInterface == null && (tids = TargetInterfaceType.getSupportedTargetInterfaces(device.hardware().targetPart())) != null && tids.length == 1) {
            this.detectedTargetInterface = tids[0];
        }
        this.targetInterface = this.detectedTargetInterface;
    }

    private boolean persistSelectedCryptoProfile() {
        return CryptoPreference.PERSIST_PROFILE_SELECTION.boolValue();
    }

    public boolean containsDefaultValues() {
        if (this.cryptoProfileID != null) {
            return false;
        }
        if (this.detectedTargetInterface == null) {
            return this.targetInterface == null;
        }
        return this.detectedTargetInterface.equals(this.targetInterface);
    }

    public Collection<String> marshall() {
        ArrayList<String> values = new ArrayList<String>();
        if (this.targetInterface != null) {
            values.add("tifId:" + this.targetInterface);
        }
        if (this.persistSelectedCryptoProfile() && this.cryptoProfileID != null) {
            values.add("cryptoId:" + this.cryptoProfileID);
        }
        return values;
    }

    public void unmarshall(Collection<String> input) throws IOException {
        for (String line : input) {
            if (line.startsWith(TARGET_INTERFACE_ID)) {
                this.targetInterface = line.split(SEPARATOR)[1];
                continue;
            }
            if (!line.startsWith(CRYPTO_PROFILE_ID)) continue;
            this.cryptoProfileID = line.split(SEPARATOR)[1];
        }
    }
}

