/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.support.mcu.internal.part.core;

import com.silabs.ss.support.mcu.api.part.core.IMemoryRegion;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MemoryRegion
implements IMemoryRegion {
    private String name;
    private long address;
    private long size;
    private long pageSize;
    private int access;

    public MemoryRegion(String name, long address, long size, long pageSize, int access) {
        this.name = name;
        this.address = address;
        this.size = size;
        this.pageSize = pageSize;
        this.access = access;
    }

    @Override
    public int getAccess() {
        return this.access;
    }

    @Override
    public long getAddress() {
        return this.address;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public long getPageSize() {
        return this.pageSize;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return "name=" + this.name + ",addr=0x" + Long.toHexString(this.address) + ",size=0x" + Long.toHexString(this.size) + ",pageSize=0x" + Long.toHexString(this.pageSize) + ",access=" + this.accessString();
    }

    public static MemoryRegion fromString(String name, String addrStr, String sizeStr, String pageSizeStr, String accessStr) throws Exception {
        long address = Long.decode(addrStr);
        long size = Long.decode(sizeStr);
        long pageSize = 0L;
        if (pageSizeStr != null) {
            pageSize = Long.decode(pageSizeStr);
        }
        int access = MemoryRegion.fromAccessString(accessStr);
        return new MemoryRegion(name, address, size, pageSize, access);
    }

    public static MemoryRegion fromString(String serializedRegion) throws Exception {
        Pattern pattern;
        Matcher matcher;
        boolean hasPageSize = serializedRegion.contains("pageSize");
        String expression = "name=(.*),addr=(.*),size=(.*)";
        if (hasPageSize) {
            expression = String.valueOf(expression) + ",pageSize=(.*)";
        }
        if (!(matcher = (pattern = Pattern.compile(expression = String.valueOf(expression) + ",access=(.*)")).matcher(serializedRegion)).matches()) {
            throw new Exception("Invalid memory region format: " + serializedRegion);
        }
        String name = matcher.group(1);
        String pageSize = null;
        String accessStr = null;
        if (hasPageSize) {
            pageSize = matcher.group(4);
            accessStr = matcher.group(5);
        } else {
            accessStr = matcher.group(4);
        }
        return MemoryRegion.fromString(name, matcher.group(2), matcher.group(3), pageSize, accessStr);
    }

    private String accessString() {
        String accessString = "";
        if ((this.access & 1) != 0) {
            accessString = String.valueOf(accessString) + "r";
        }
        if ((this.access & 2) != 0) {
            accessString = String.valueOf(accessString) + "w";
        }
        if ((this.access & 4) != 0) {
            accessString = String.valueOf(accessString) + "x";
        }
        return accessString;
    }

    private static int fromAccessString(String accessString) {
        int value = 0;
        if (accessString.contains("r")) {
            value |= 1;
        }
        if (accessString.contains("w")) {
            value |= 2;
        }
        if (accessString.contains("x")) {
            value |= 4;
        }
        return value;
    }
}

