/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.support.mcu.internal.part.core;

import com.silabs.java.utils.TextUtils;
import com.silabs.ss.platform.api.device.core.IDevice;
import com.silabs.ss.platform.api.rcp.core.IConfirmationService;
import com.silabs.ss.support.mcu.api.part.core.secure.IFirmwareUpdater;
import com.silabs.ss.support.mcu.api.part.core.secure.IFirmwareUpdater2;
import com.silabs.ss.support.mcu.internal.part.core.Activator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

public class WriteFirmwareJob
extends Job {
    private static final int POST_FLASH_WAIT_TIME = 5000;
    private final IDevice device;
    private final IPath firmwarePath;
    private final String fileVersion;
    private final boolean warnVersionChange;
    private final Job postRunJob;

    public WriteFirmwareJob(IDevice device, IPath firmwarePath, String fileVersion, boolean warnVersionChange, Job postRunJob) {
        super("Firmware Updater");
        this.device = device;
        this.firmwarePath = firmwarePath;
        this.fileVersion = fileVersion;
        this.warnVersionChange = warnVersionChange;
        this.postRunJob = postRunJob;
    }

    protected IFirmwareUpdater2 getFirmwareUpdater(IDevice device) {
        IFirmwareUpdater updater = (IFirmwareUpdater)Platform.getAdapterManager().loadAdapter((Object)device, IFirmwareUpdater.class.getName());
        return updater instanceof IFirmwareUpdater2 ? (IFirmwareUpdater2)updater : null;
    }

    private int compareFirmwareVersions(IFirmwareUpdater2 fwUpdater, Version fileVersion, Version deviceVersion) {
        if (fileVersion == null) {
            return 1;
        }
        if (deviceVersion == null) {
            return -1;
        }
        return fwUpdater.compareFirmwareVersions(fileVersion, deviceVersion);
    }

    private Version getDeviceVersion(IDevice device, IFirmwareUpdater2 fwUpdater) {
        String version = fwUpdater.getFirmwareVersion(device, 0);
        if (version != null) {
            return fwUpdater.firmwareStringToVersion(version);
        }
        return null;
    }

    private String getFirmwareDisplayLabel(IFirmwareUpdater2 fwUpdater) {
        String label = fwUpdater == null ? "firmware" : fwUpdater.getFirmwareLabel();
        return TextUtils.isEmpty((String)label) ? "firmware" : label;
    }

    protected IConfirmationService getConfirmationService() {
        ServiceReference serviceReference = Activator.getContext().getServiceReference(IConfirmationService.class.getName());
        return (IConfirmationService)Activator.getContext().getService(serviceReference);
    }

    private boolean warnWithCancel(IFirmwareUpdater2 fwUpdater, Version newVersion, Version oldVersion) {
        IConfirmationService service = this.getConfirmationService();
        if (service == null || fwUpdater == null) {
            return true;
        }
        StringBuilder message = new StringBuilder();
        String label = this.getFirmwareDisplayLabel(fwUpdater);
        message.append(String.format("This operation requires a different version of your %s.", label));
        message.append(String.format("%nFlashing %s will erase all previously flashed content on your device", label));
        if (oldVersion != null) {
            message.append(String.format("%n\tOld Version: %s", fwUpdater.firmwareVersionToString(oldVersion)));
        }
        if (newVersion != null) {
            message.append(String.format("%n\tNew Version: %s", fwUpdater.firmwareVersionToString(newVersion)));
        }
        message.append("\nContinue?");
        return service.confirmNoTogglePreference("Firmware Update", message.toString());
    }

    protected IStatus runPostJob(Job postJob) {
        IStatus status;
        postJob.setUser(true);
        postJob.schedule();
        try {
            postJob.join();
            status = postJob.getResult();
        }
        catch (InterruptedException e) {
            Activator.reporter.logException((Throwable)e);
            status = Status.error((String)"Failed to complete flashing operation", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        return status;
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        IFirmwareUpdater2 fwUpdater = this.getFirmwareUpdater(this.device);
        monitor.beginTask("Loading " + this.getFirmwareDisplayLabel(fwUpdater), 100);
        if (fwUpdater != null && this.firmwarePath != null) {
            Version deviceVersion = this.getDeviceVersion(this.device, fwUpdater);
            Version fwFileVersion = fwUpdater.firmwareStringToVersion(this.fileVersion);
            if (this.compareFirmwareVersions(fwUpdater, fwFileVersion, deviceVersion) != 0) {
                boolean allowUpdate = true;
                if (this.warnVersionChange) {
                    allowUpdate = this.warnWithCancel(fwUpdater, fwFileVersion, deviceVersion);
                }
                if (allowUpdate) {
                    status = fwUpdater.updateFirmware(this.device, 0, this.firmwarePath, monitor);
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    monitor.worked(50);
                } else {
                    status = Status.CANCEL_STATUS;
                }
            }
        }
        if (status.isOK() && this.postRunJob != null) {
            status = this.runPostJob(this.postRunJob);
        }
        monitor.worked(50);
        return status;
    }
}

