/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.support.mcu.internal.scripting;

import com.silabs.ss.support.mcu.internal.scripting.HexFileUtils;
import com.silabs.ss.support.mcu.internal.scripting.IHexFileLineInfo;

public class DataHexFileLineInfo
implements IHexFileLineInfo {
    private int len;
    private int address;
    private byte[] data;

    public DataHexFileLineInfo(int maxLineLen, int address) {
        this.data = new byte[maxLineLen];
        this.address = address;
    }

    public DataHexFileLineInfo(String line) {
        this.len = HexFileUtils.readHex(line, 1, 1);
        this.data = new byte[this.len];
        this.address = HexFileUtils.readHex(line, 3, 2);
        int i = 0;
        while (i < this.len) {
            this.data[i] = (byte)HexFileUtils.readHex(line, 9 + i * 2, 1);
            ++i;
        }
    }

    @Override
    public String formatLine() {
        byte[] lineBytes = new byte[4 + this.len];
        int lineBytesIndex = 0;
        StringBuilder sb = new StringBuilder(":");
        sb.append(HexFileUtils.formatAsHex(this.len, 2));
        lineBytes[lineBytesIndex++] = HexFileUtils.asByte(this.len);
        sb.append(HexFileUtils.formatAsHex(this.address, 4));
        lineBytes[lineBytesIndex++] = HexFileUtils.asByte(this.address);
        lineBytes[lineBytesIndex++] = HexFileUtils.asByte(this.address >> 8);
        sb.append(HexFileUtils.formatAsHex(0, 2));
        lineBytes[lineBytesIndex++] = HexFileUtils.asByte(0);
        int i = 0;
        while (i < this.len) {
            sb.append(HexFileUtils.formatAsHex(this.data[i], 2));
            lineBytes[lineBytesIndex++] = this.data[i];
            ++i;
        }
        sb.append(HexFileUtils.formatAsHex(HexFileUtils.getChecksum(lineBytes), 2));
        return sb.toString();
    }

    public int getLen() {
        return this.len;
    }

    public void setLen(int len) {
        this.len = len;
    }

    public int getAddress() {
        return this.address;
    }

    public byte[] array() {
        return this.data;
    }

    public String toString() {
        return this.formatLine();
    }
}

