/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.support.mcu.internal.scripting;

import com.silabs.ss.support.mcu.internal.scripting.HexFileUtils;
import com.silabs.ss.support.mcu.internal.scripting.IHexFileLineInfo;

public class ExtAddrLineInfo
implements IHexFileLineInfo {
    private int segBaseAddress;
    private int recordType;

    public ExtAddrLineInfo(String line, int recordType) {
        this.segBaseAddress = HexFileUtils.readHex(line, 9, 2);
        this.recordType = recordType;
    }

    public ExtAddrLineInfo(int segBaseAddress, int recordType) {
        this.segBaseAddress = segBaseAddress;
        this.recordType = recordType;
    }

    @Override
    public String formatLine() {
        byte[] byArray = new byte[6];
        byArray[0] = 2;
        byArray[3] = -1;
        byArray[4] = -1;
        byArray[5] = -1;
        byte[] lineBytes = byArray;
        StringBuilder sb = new StringBuilder(":020000");
        sb.append(HexFileUtils.formatAsHex(this.recordType, 2));
        lineBytes[3] = HexFileUtils.asByte(this.recordType);
        sb.append(HexFileUtils.formatAsHex(this.segBaseAddress, 4));
        lineBytes[4] = HexFileUtils.asByte(this.segBaseAddress);
        lineBytes[5] = HexFileUtils.asByte(this.segBaseAddress >> 8);
        sb.append(HexFileUtils.formatAsHex(HexFileUtils.getChecksum(lineBytes), 2));
        return sb.toString();
    }

    public int getSegBaseAddress() {
        return this.segBaseAddress;
    }

    public String toString() {
        return this.formatLine();
    }
}

