/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.support.mcu.internal.scripting;

import com.silabs.java.utils.Pair;
import com.silabs.ss.support.mcu.api.part.core.IIntelHexFile;
import com.silabs.ss.support.mcu.internal.scripting.DataHexFileLineInfo;
import com.silabs.ss.support.mcu.internal.scripting.ExtAddrLineInfo;
import com.silabs.ss.support.mcu.internal.scripting.HexFileUtils;
import com.silabs.ss.support.mcu.internal.scripting.IHexFileLineInfo;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class IntelHexFile
implements IIntelHexFile {
    private List<IHexFileLineInfo> lineInfos;
    private List<Integer> sectionStartIndices;

    public IntelHexFile(List<IHexFileLineInfo> lineInfos) {
        this.lineInfos = lineInfos;
        this.gatherIndexStartIndices();
    }

    public IntelHexFile() {
        this.lineInfos = new ArrayList<IHexFileLineInfo>();
    }

    private void gatherIndexStartIndices() {
        this.sectionStartIndices = new ArrayList<Integer>();
        int index = 0;
        while (index < this.lineInfos.size()) {
            IHexFileLineInfo lineInfo = this.lineInfos.get(index);
            if (lineInfo instanceof DataHexFileLineInfo) {
                DataHexFileLineInfo dataLineInfo = (DataHexFileLineInfo)lineInfo;
                int address = dataLineInfo.getAddress();
                DataHexFileLineInfo lastLineInfo = this.getPreviousDataLineInfo(index);
                if (lastLineInfo == null || lastLineInfo.getAddress() + lastLineInfo.getLen() < address) {
                    this.sectionStartIndices.add(index);
                }
            }
            ++index;
        }
    }

    private DataHexFileLineInfo getPreviousDataLineInfo(int index) {
        return this.getPrevTypedLineInfo(DataHexFileLineInfo.class, index);
    }

    private ExtAddrLineInfo getPrevExtAddressLineInfo(int index) {
        return this.getPrevTypedLineInfo(ExtAddrLineInfo.class, index);
    }

    private <T extends IHexFileLineInfo> T getPrevTypedLineInfo(Class<T> cls, int index) {
        if (index == 0) {
            return null;
        }
        IHexFileLineInfo lineInfo = this.lineInfos.get(index - 1);
        if (lineInfo.getClass().equals(cls)) {
            return (T)((IHexFileLineInfo)cls.cast(lineInfo));
        }
        return this.getPrevTypedLineInfo(cls, index - 1);
    }

    private Pair<DataHexFileLineInfo, Integer> getNextDataLineInfoAndIndex(int index) {
        if (index >= this.lineInfos.size()) {
            return null;
        }
        IHexFileLineInfo lineInfo = this.lineInfos.get(index);
        if (lineInfo instanceof DataHexFileLineInfo) {
            return new Pair((Object)((DataHexFileLineInfo)lineInfo), (Object)index);
        }
        return this.getNextDataLineInfoAndIndex(index + 1);
    }

    @Override
    public String getContents() {
        return HexFileUtils.getHexFileContents(this.lineInfos);
    }

    @Override
    public int getNumSections() {
        return this.sectionStartIndices.size();
    }

    @Override
    public int getAddress(int sectionIndex) {
        int startIndex = this.sectionStartIndices.get(sectionIndex);
        Pair<DataHexFileLineInfo, Integer> nextDataPair = this.getNextDataLineInfoAndIndex(startIndex);
        int address = 0;
        if (nextDataPair != null) {
            address = ((DataHexFileLineInfo)nextDataPair.first).getAddress();
            ExtAddrLineInfo info = this.getPrevExtAddressLineInfo((Integer)nextDataPair.second);
            if (info != null) {
                address |= info.getSegBaseAddress() << 16;
            }
        }
        return address;
    }

    @Override
    public byte[] getBytes(int sectionIndex) {
        List<DataHexFileLineInfo> sectionInfos = this.getSectionInfos(sectionIndex);
        return IntelHexFile.getBytes(sectionInfos, IntelHexFile.getNumBytes(sectionInfos));
    }

    private static byte[] getBytes(List<DataHexFileLineInfo> sectionInfos, int numBytes) {
        byte[] bytes = new byte[numBytes];
        int pos = 0;
        for (DataHexFileLineInfo lineInfo : sectionInfos) {
            int len = lineInfo.getLen();
            System.arraycopy(lineInfo.array(), 0, bytes, pos, len);
            pos += len;
        }
        return bytes;
    }

    private static int getNumBytes(List<DataHexFileLineInfo> sectionInfos) {
        int totalLen = 0;
        for (DataHexFileLineInfo lineInfo : sectionInfos) {
            totalLen += lineInfo.getLen();
        }
        return totalLen;
    }

    private List<DataHexFileLineInfo> getSectionInfos(int sectionIndex) {
        int startIndex = this.sectionStartIndices.get(sectionIndex);
        ArrayList<DataHexFileLineInfo> sectionInfos = new ArrayList<DataHexFileLineInfo>();
        int nextIndex = sectionIndex + 1 == this.sectionStartIndices.size() ? this.lineInfos.size() : this.sectionStartIndices.get(sectionIndex + 1).intValue();
        int index = startIndex;
        while (index < nextIndex) {
            IHexFileLineInfo lineInfo = this.lineInfos.get(index);
            if (lineInfo instanceof DataHexFileLineInfo) {
                sectionInfos.add((DataHexFileLineInfo)lineInfo);
            }
            ++index;
        }
        return sectionInfos;
    }

    @Override
    public void addSection(int address, byte[] bytes) {
        int i = 0;
        while (i < this.lineInfos.size()) {
            DataHexFileLineInfo prevInfo = this.getPreviousDataLineInfo(i);
            IHexFileLineInfo nextInfo = this.lineInfos.get(i);
            int bytesLen = bytes.length;
            int start = prevInfo == null ? 0 : prevInfo.getAddress() + prevInfo.getLen();
            int end = nextInfo instanceof DataHexFileLineInfo ? ((DataHexFileLineInfo)nextInfo).getAddress() : 0;
            int length = end - start;
            if (address >= start && address < end) {
                if (bytesLen <= length) {
                    this.addNewInfos(i, address, bytes);
                    return;
                }
                throw new IllegalArgumentException(MessageFormat.format("Could not add {0} bytes at address {1} without overwriting existing bytes", bytesLen, address));
            }
            ++i;
        }
        this.addNewInfos(this.lineInfos.size(), address, bytes);
    }

    private void addNewInfos(int index, int address, byte[] bytes) {
        Pair<DataHexFileLineInfo, Integer> pair;
        if (address >= 65536) {
            int segBaseAddress = address >> 16 & 0xFFFF;
            ExtAddrLineInfo extAddressLineInfo = this.getPrevExtAddressLineInfo(index);
            if (extAddressLineInfo == null || extAddressLineInfo.getSegBaseAddress() != segBaseAddress) {
                extAddressLineInfo = new ExtAddrLineInfo(segBaseAddress, 4);
                this.lineInfos.add(index, extAddressLineInfo);
                ++index;
            }
        }
        int initialLength = (pair = this.getNextDataLineInfoAndIndex(0)) == null ? 0 : ((DataHexFileLineInfo)pair.first).getLen();
        int maxLineLength = this.lineInfos.isEmpty() ? 16 : Math.max(16, initialLength);
        HexFileUtils.addToLineInfos(this.lineInfos, index, maxLineLength, address, bytes);
    }

    public List<IHexFileLineInfo> getLineInfos() {
        return this.lineInfos;
    }
}

