/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.support.mcu.internal.scripting;

import com.silabs.ss.platform.api.device.core.IDevice;
import com.silabs.ss.platform.api.scripting.core.ScriptEngineContext;
import com.silabs.ss.support.mcu.api.part.core.IExecutionCompleteCallback;
import com.silabs.ss.support.mcu.api.part.core.IIntelHexFile;
import com.silabs.ss.support.mcu.api.part.core.ISLSHexSupportModule;
import com.silabs.ss.support.mcu.api.part.core.UploadJob;
import com.silabs.ss.support.mcu.internal.scripting.HexFileUtils;
import com.silabs.ss.support.mcu.internal.scripting.IHexFileLineInfo;
import com.silabs.ss.support.mcu.internal.scripting.IntelHexFile;
import java.io.IOException;
import java.util.List;
import javax.script.ScriptException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

public class SLSHexSupportModule
implements ISLSHexSupportModule {
    public SLSHexSupportModule(ScriptEngineContext context) {
    }

    public String getName() {
        return "hexSupport";
    }

    public int getVersion() {
        return 0;
    }

    @Override
    public IIntelHexFile createHexFile(String contents) throws ScriptException {
        try {
            List<IHexFileLineInfo> lines = HexFileUtils.readHexFileContents(contents);
            return new IntelHexFile(lines);
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
    }

    @Override
    public IIntelHexFile newEmptyHexFile() {
        return new IntelHexFile();
    }

    @Override
    public void programFlash(IExecutionCompleteCallback callback, IDevice device, String path) throws ScriptException {
        UploadJob job = new UploadJob(device, (IPath)new Path(path), false, false, false);
        try {
            this.execute(job, callback);
        }
        catch (CoreException e) {
            throw new ScriptException((Exception)((Object)e));
        }
    }

    private void execute(Job job, final IExecutionCompleteCallback callback) throws CoreException {
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (callback != null) {
                    callback.executionComplete(event.getResult());
                }
            }
        });
        job.setUser(true);
        job.schedule();
    }
}

