/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.internal.utils.files.monitor;

import com.silabs.java.internal.utils.files.monitor.IDirectoryMonitorImpl;
import com.silabs.java.utils.files.monitor.IDirectoryNotifier;
import com.silabs.java.utils.log.Log;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;

final class WatchServiceDirectoryMonitorImpl
implements IDirectoryMonitorImpl {
    private final boolean checkModified;
    private WatchService ws;
    private Path directory;
    private IDirectoryNotifier notifier;
    private Thread runner;

    public WatchServiceDirectoryMonitorImpl(boolean checkModified) {
        this.checkModified = checkModified;
    }

    @Override
    public void init(Path directory, IDirectoryNotifier notifier) throws IOException {
        this.directory = directory;
        this.notifier = notifier;
        if (directory == null || notifier == null) {
            throw new IllegalArgumentException("Input directory and notifier callback cannot be null!");
        }
        this.ws = FileSystems.getDefault().newWatchService();
        WatchEvent.Kind[] watchKinds = this.checkModified ? new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE} : new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE};
        directory.register(this.ws, watchKinds);
    }

    @Override
    public void run() {
        this.runner = Thread.currentThread();
        WatchKey key = null;
        try {
            do {
                key = this.ws.take();
                Thread.sleep(50L);
                for (WatchEvent<?> e : key.pollEvents()) {
                    IDirectoryNotifier.TYPE type;
                    WatchEvent.Kind<?> kind = e.kind();
                    if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                    if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                        type = IDirectoryNotifier.TYPE.CREATED;
                    } else if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
                        type = IDirectoryNotifier.TYPE.DELETED;
                    } else {
                        if (kind != StandardWatchEventKinds.ENTRY_MODIFY) continue;
                        type = IDirectoryNotifier.TYPE.CHANGED;
                    }
                    this.notifyEvent(type, (Path)e.context());
                }
            } while (key.reset());
        }
        catch (ClosedWatchServiceException closedWatchServiceException) {
        }
        catch (InterruptedException ioe) {
            Log.warning("Watch service interrupted", ioe);
            Thread.currentThread().interrupt();
        }
        this.runner = null;
    }

    protected void notifyEvent(IDirectoryNotifier.TYPE type, Path path) {
        if (type == IDirectoryNotifier.TYPE.CHANGED && Files.isDirectory(this.directory.resolve(path), new LinkOption[0])) {
            return;
        }
        try {
            this.notifier.fileEvent(type, this.directory.resolve(path));
        }
        catch (Throwable t) {
            Log.error("Callback threw an exception! ", t);
        }
    }

    @Override
    public void stop() {
        try {
            this.ws.close();
        }
        catch (IOException ioe) {
            Log.warning("Could not close watch service", ioe);
        }
    }

    @Override
    public Thread runningThread() {
        return this.runner;
    }
}

