/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class CSVFile {
    private List<String> header;
    private final BufferedReader reader;
    private final String delimiters;

    public CSVFile(InputStream file, boolean hasHeader, String delimiters) throws IOException {
        this.reader = new BufferedReader(new InputStreamReader(file));
        this.delimiters = delimiters;
        if (hasHeader) {
            this.header = this.readLine();
        }
    }

    public List<String> readLine() throws IOException {
        String line = this.reader.readLine();
        if (line == null) {
            return null;
        }
        String[] tokens = line.split(this.delimiters);
        ArrayList<String> ret = new ArrayList<String>(tokens.length);
        for (String t : tokens) {
            ret.add(t.trim());
        }
        return ret;
    }

    public List<String> getHeader() {
        return this.header;
    }

    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

