/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public final class CollectionUtils {
    public static <T> boolean sameContent(Collection<T> input1, Collection<T> input2) {
        if (input1 == input2) {
            return true;
        }
        if (input1 == null) {
            return input2 == null || input2.isEmpty();
        }
        if (input2 == null) {
            return input1.isEmpty();
        }
        if (!(input1 instanceof Set)) {
            input1 = new HashSet<T>(input1);
        }
        if (!(input2 instanceof Set)) {
            input2 = new HashSet<T>(input2);
        }
        if (input1.size() != input2.size()) {
            return false;
        }
        return input1.containsAll(input2);
    }

    public static <T, K, U, M extends Map<K, U>> Collector<T, ?, M> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, Supplier<M> mapSupplier) {
        return Collectors.toMap(keyMapper, valueMapper, (u, v) -> {
            throw new IllegalStateException("Duplicate key " + u + "  " + v);
        }, mapSupplier);
    }
}

