/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils;

import com.silabs.java.utils.TextUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class InfoBlock {
    private final Map<String, List<String>> map = new LinkedHashMap<String, List<String>>();
    private final List<String> looseLines = new ArrayList<String>();

    InfoBlock() {
    }

    public void addKeyValue(String key, String value) {
        List<String> list = this.map.get(key);
        if (list == null) {
            list = new ArrayList<String>();
            this.map.put(key, list);
        }
        list.add(value);
    }

    public void addLooseLine(String line) {
        line = line.trim();
        this.looseLines.add(line);
    }

    public String[] looseLines() {
        return this.looseLines.toArray(new String[0]);
    }

    public void replaceKeyValue(String key, String value) {
        if (this.map.containsKey(key)) {
            this.map.remove(key);
        }
        this.addKeyValue(key, value);
    }

    public String description() {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        for (String s : this.looseLines) {
            sb.append(sep).append(s);
            sep = " ";
        }
        return sb.toString();
    }

    public int keyCount(String key) {
        List<String> list = this.map.get(key);
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    public String value(String key, int index) {
        List<String> list = this.map.get(key);
        if (list == null) {
            return null;
        }
        if (index >= list.size()) {
            return null;
        }
        return list.get(index);
    }

    public String value(String key) throws IOException {
        List<String> list = this.map.get(key);
        if (list == null) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        throw new IOException("Key '" + key + "' maps to more than one value.");
    }

    public String[] keys() {
        return this.map.keySet().toArray(new String[0]);
    }

    public static InfoBlock readInfoBlock(Collection<String> lines) {
        InfoBlock block = new InfoBlock();
        for (String l : lines) {
            if (l.trim().startsWith("#")) continue;
            String[] keyValue = TextUtils.readKeyValue(l.trim());
            if (keyValue == null) {
                block.addLooseLine(l);
                continue;
            }
            block.addKeyValue(keyValue[0], keyValue[1]);
        }
        return block;
    }

    public static InfoBlock readInfoBlock(Map<String, List<String>> keyValues) {
        InfoBlock block = new InfoBlock();
        for (Map.Entry<String, List<String>> entry : keyValues.entrySet()) {
            List<String> valueList = entry.getValue();
            for (String v : valueList) {
                block.addKeyValue(entry.getKey(), v);
            }
        }
        return block;
    }

    public String toString(int ident, String ... ignoredKeys) {
        StringBuilder id = new StringBuilder();
        for (int i = 0; i < ident; ++i) {
            id.append(' ');
        }
        StringBuilder sb = new StringBuilder();
        List<String> ignoredKeysList = Arrays.asList(ignoredKeys);
        for (String bk : this.keys()) {
            if (ignoredKeysList.contains(bk)) continue;
            int cnt = this.keyCount(bk);
            for (int i = 0; i < cnt; ++i) {
                sb.append(id.toString()).append(bk).append("=").append(this.value(bk, i)).append("\n");
            }
        }
        for (String ll : this.looseLines()) {
            sb.append(id.toString()).append(ll).append("\n");
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString(0, new String[0]);
    }
}

