/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils;

import com.silabs.java.utils.InfoBlock;
import com.silabs.java.utils.TextUtils;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class InfoBlockFile {
    private final Map<String, String> globalKeyValues = new LinkedHashMap<String, String>();
    private final Map<String, InfoBlock> blocks = new LinkedHashMap<String, InfoBlock>();
    private final List<String> looselines = new ArrayList<String>();

    private InfoBlockFile() {
    }

    public String[] globalKeys() {
        return this.globalKeyValues.keySet().toArray(new String[0]);
    }

    public String[] blockKeys() {
        return this.blocks.keySet().toArray(new String[0]);
    }

    public String[] looseLines() {
        return this.looselines.toArray(new String[0]);
    }

    public String globalValue(String key) {
        return this.globalKeyValues.get(key);
    }

    public InfoBlock block(String key) {
        return this.blocks.get(key);
    }

    public InfoBlock createBlock(String key) {
        InfoBlock ib = new InfoBlock();
        this.blocks.put(key, ib);
        return ib;
    }

    public void putKeyValue(String key, String value) {
        this.globalKeyValues.put(key, value);
    }

    public void clearKeyValue(String key) {
        this.globalKeyValues.remove(key);
    }

    public void addLooseLine(String line) {
        this.looselines.add(line);
    }

    public static InfoBlockFile read(URL url) throws IOException {
        try (LineNumberReader lnr = new LineNumberReader(new InputStreamReader(url.openStream()));){
            InfoBlockFile infoBlockFile = InfoBlockFile.read(lnr);
            return infoBlockFile;
        }
    }

    public static InfoBlockFile createEmpty() {
        return new InfoBlockFile();
    }

    public static InfoBlockFile read(String data) throws IOException {
        try (LineNumberReader lnr = new LineNumberReader(new StringReader(data));){
            InfoBlockFile infoBlockFile = InfoBlockFile.read(lnr);
            return infoBlockFile;
        }
    }

    public static InfoBlockFile read(File f) throws IOException {
        try (LineNumberReader lnr = new LineNumberReader(new FileReader(f, StandardCharsets.UTF_8));){
            InfoBlockFile infoBlockFile = InfoBlockFile.read(lnr);
            return infoBlockFile;
        }
    }

    private static InfoBlockFile read(LineNumberReader lnr) throws IOException {
        String line;
        InfoBlockFile bf = new InfoBlockFile();
        String blockId = null;
        ArrayList<String> currentLines = new ArrayList<String>();
        while ((line = lnr.readLine()) != null) {
            if (line.startsWith("#") || line.trim().length() == 0) continue;
            line = line.trim();
            if (blockId == null) {
                int i = line.indexOf(123);
                if (i == 0) {
                    throw new IOException("Wrong format. Expecting: 'blockId {'");
                }
                if (i == -1 || line.charAt(i - 1) == '$') {
                    int index = line.indexOf("=");
                    if (index == -1) {
                        bf.looselines.add(line);
                        continue;
                    }
                    String[] keyValue = TextUtils.readKeyValue(line);
                    if (keyValue == null) {
                        throw new IOException("Invalid line: " + line);
                    }
                    bf.globalKeyValues.put(keyValue[0], keyValue[1]);
                    continue;
                }
                blockId = line.substring(0, i).trim();
                continue;
            }
            if ("}".equals(line)) {
                InfoBlock b = InfoBlock.readInfoBlock(currentLines);
                bf.blocks.put(blockId, b);
                currentLines.clear();
                blockId = null;
                continue;
            }
            currentLines.add(line);
        }
        return bf;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String s : this.globalKeys()) {
            sb.append(s + "=" + this.globalValue(s) + "\n");
        }
        for (String b : this.blockKeys()) {
            sb.append(b).append(" {\n");
            InfoBlock ib = this.block(b);
            for (String bk : ib.keys()) {
                int cnt = ib.keyCount(bk);
                for (int i = 0; i < cnt; ++i) {
                    sb.append("  ").append(bk).append("=").append(ib.value(bk, i)).append("\n");
                }
            }
            for (String ll : ib.looseLines()) {
                sb.append("  ").append(ll).append("\n");
            }
            sb.append("}\n");
        }
        for (String ll : this.looseLines()) {
            sb.append(ll).append("\n");
        }
        return sb.toString();
    }
}

