/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils;

import com.silabs.java.utils.ExceptionUtils;
import com.silabs.java.utils.TextUtils;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LangUtilities {
    private static String DEFAULT_ESCAPER = "\\";

    public static int bitcount(int n) {
        int tmp = n - (n >> 1 & 0xDB6DB6DB) - (n >> 2 & 0x49249249);
        return (tmp + (tmp >> 3) & 0xC71C71C7) % 63;
    }

    public static int bitcount(byte[] bytes) {
        int n = 0;
        int rem = 0;
        for (int i = 0; i < bytes.length; ++i) {
            if (i % 3 != 2 || (rem |= (bytes[i] & 0xFF) << i % 3 * 8) == 0) continue;
            n += LangUtilities.bitcount(rem);
            rem = 0;
        }
        if (rem != 0) {
            n += LangUtilities.bitcount(rem);
        }
        return n;
    }

    public static String[] enumNames(Class<? extends Enum<?>> x) {
        Enum<?>[] arr = x.getEnumConstants();
        if (arr == null) {
            throw new IllegalArgumentException("Not an enum");
        }
        String[] names = new String[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            names[i] = arr[i].name();
        }
        return names;
    }

    public static int hexDigitValue(char digit) {
        if ('0' <= digit && digit <= '9') {
            return digit - 48;
        }
        if ('A' <= digit && digit <= 'F') {
            return digit - 65 + 10;
        }
        if ('a' <= digit && digit <= 'f') {
            return digit - 97 + 10;
        }
        return -1;
    }

    public static boolean isOneBitSet(int n) {
        if (n == 0) {
            return false;
        }
        return (n & n - 1) == 0;
    }

    public static boolean parseBoolean(String s) {
        if (s == null) {
            return false;
        }
        return "ENABLE".equalsIgnoreCase(s = s.trim()) || "ENABLED".equalsIgnoreCase(s) || "TRUE".equalsIgnoreCase(s) || "YES".equalsIgnoreCase(s) || "1".equals(s);
    }

    public static boolean parseBoolean(Object x) {
        if (x instanceof String) {
            return LangUtilities.parseBoolean((String)x);
        }
        if (x instanceof Boolean) {
            return (Boolean)x;
        }
        return false;
    }

    public static boolean parseBoolean(String s, boolean strict) throws Exception {
        HashSet<String> validChoices = new HashSet<String>();
        validChoices.add("yes");
        validChoices.add("no");
        validChoices.add("true");
        validChoices.add("false");
        validChoices.add("1");
        validChoices.add("0");
        if (!validChoices.contains(s.toLowerCase(Locale.ROOT))) {
            throw new Exception("Unable to parse " + s + " as a Boolean type!");
        }
        return LangUtilities.parseBoolean(s);
    }

    public static byte[] parseBytes(String text) throws ParseException {
        if (text.contains(",")) {
            String[] split = text.split(",");
            byte[] arr = new byte[split.length];
            for (int i = 0; i < split.length; ++i) {
                String s = split[i].trim();
                int n = s.startsWith("0x") || s.startsWith("0X") ? Integer.parseInt(s.substring(2), 16) : Integer.parseInt(s);
                arr[i] = (byte)n;
            }
            return arr;
        }
        StringBuffer realText = new StringBuffer();
        try {
            int i;
            int added = 0;
            for (i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (Character.isWhitespace(c)) continue;
                realText.append(c);
                if (++added % 2 != 0) continue;
                realText.append(' ');
            }
            do {
                if ((i = realText.indexOf("0x ")) < 0) continue;
                realText.delete(i, i + 3);
            } while (i >= 0);
            return LangUtilities.toBytesStrict(realText.toString().trim());
        }
        catch (ParseException e) {
            throw new ParseException(realText.toString() + " : " + e.getMessage(), 0);
        }
    }

    public static byte[] parseEui64(String text) throws ParseException {
        byte[] bs = LangUtilities.parseBytes(text);
        LangUtilities.revertBytes(bs);
        return bs;
    }

    public static long parseLong(String s) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException("Expecting number: " + s);
        }
        try {
            s = s.trim();
            if (s.startsWith("0x") || s.startsWith("0X")) {
                if ((s = s.substring(2)).length() > 15) {
                    char firstCh = s.charAt(0);
                    if (firstCh == '8' || firstCh == '9' || firstCh >= 'A' && firstCh <= 'F' || firstCh >= 'a' && firstCh <= 'f') {
                        throw new NumberFormatException("Cannot parse unsigned long.");
                    }
                    return Long.parseLong(s, 16);
                }
                return Long.parseLong(s, 16);
            }
            return Long.parseLong(s);
        }
        catch (NumberFormatException nfe) {
            throw nfe;
        }
        catch (Exception e) {
            throw new NumberFormatException("Expecting number: " + s);
        }
    }

    public static int parseInt(String s) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException("Expecting number: " + s);
        }
        try {
            s = s.trim();
            if (s.startsWith("0x") || s.startsWith("0X")) {
                if ((s = s.substring(2)).length() == 8) {
                    char firstCh = s.charAt(0);
                    if (firstCh == '8' || firstCh == '9' || firstCh >= 'A' && firstCh <= 'F' || firstCh >= 'a' && firstCh <= 'f') {
                        long l = Long.parseLong(s, 16);
                        return (int)(l & 0xFFFFFFFFFFFFFFFFL);
                    }
                    return Integer.parseInt(s, 16);
                }
                return Integer.parseInt(s, 16);
            }
            return Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            throw nfe;
        }
        catch (Exception e) {
            throw new NumberFormatException("Expecting number: " + s);
        }
    }

    public static int parseHexInt(String input) throws NumberFormatException {
        if (input == null) {
            throw new NumberFormatException("Expecting number: " + (String)input);
        }
        if (!((String)(input = ((String)input).trim())).startsWith("0x") && !((String)input).startsWith("0X")) {
            input = "0x" + (String)input;
        }
        return LangUtilities.parseInt((String)input);
    }

    public static double parseDouble(String s) throws ParseException {
        return LangUtilities.parseDouble(s, Locale.getDefault());
    }

    public static double parseDouble(String s, Locale l) throws ParseException {
        if (s == null) {
            throw new NumberFormatException("Expecting number: " + s);
        }
        try {
            NumberFormat nf = NumberFormat.getNumberInstance(l);
            Number n = nf.parse(s);
            return n.doubleValue();
        }
        catch (Exception exception) {
            return Double.parseDouble(s);
        }
    }

    public static byte[] revertBytes(byte[] bytes) {
        for (int i = 0; i < bytes.length / 2; ++i) {
            byte reg = bytes[i];
            bytes[i] = bytes[bytes.length - i - 1];
            bytes[bytes.length - i - 1] = reg;
        }
        return bytes;
    }

    public static byte[] toBytesStrict(String input) throws ParseException {
        byte[] bytes = new byte[input.length() / 2 + 1];
        int byteIndex = 0;
        boolean midNibble = false;
        int hiNibble = 0;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (Character.isWhitespace(c)) {
                if (!midNibble) continue;
                throw new ParseException("Incomplete byte.", i - 1);
            }
            int nibble = LangUtilities.hexDigitValue(c);
            if (nibble == -1) {
                throw new ParseException("Not a hex digit.", i);
            }
            if (midNibble) {
                midNibble = false;
                bytes[byteIndex++] = (byte)((hiNibble << 4) + nibble);
                continue;
            }
            hiNibble = nibble;
            midNibble = true;
        }
        if (midNibble) {
            throw new ParseException("Partial nibble at end.", input.length() - 1);
        }
        byte[] trimmed = new byte[byteIndex];
        System.arraycopy(bytes, 0, trimmed, 0, byteIndex);
        return trimmed;
    }

    public static byte[] toByteLight(String input) {
        StringBuilder strippedInput = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char character = input.charAt(i);
            if (!TextUtils.isHexChar(character)) continue;
            strippedInput.append(character);
        }
        if (strippedInput.length() % 2 != 0) {
            strippedInput.insert(0, '0');
        }
        try {
            return LangUtilities.parseBytes(strippedInput.toString());
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static int compare(int x, int y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    private static String escape(String string, String escaper, Object ... escapees) {
        if (string != null) {
            escaper = Matcher.quoteReplacement(escaper);
            for (Object escapee : escapees) {
                string = string.replaceAll("(" + Pattern.quote(escapee.toString()) + ")", escaper + "$1");
            }
        }
        return string;
    }

    private static String unescape(String string, String escaper, Object ... escapees) {
        if (string != null) {
            escaper = Matcher.quoteReplacement(escaper);
            for (Object escapee : escapees) {
                string = string.replaceAll(escaper + "(" + Pattern.quote(escapee.toString()) + ")", "$1");
            }
        }
        return string;
    }

    public static String escape(String string, String escaper, String ... escapees) {
        return LangUtilities.escape(string, escaper, (Object[])escapees);
    }

    public static String escape(String string, String escaper, Character ... escapees) {
        return LangUtilities.escape(string, escaper, (Object[])escapees);
    }

    public static String escape(String string, String ... escapees) {
        return LangUtilities.escape(string, DEFAULT_ESCAPER, (Object[])escapees);
    }

    public static String escape(String string, Character ... escapees) {
        return LangUtilities.escape(string, DEFAULT_ESCAPER, (Object[])escapees);
    }

    public static String unescape(String string, String escaper, String ... escapees) {
        return LangUtilities.unescape(string, escaper, (Object[])escapees);
    }

    public static String unescape(String string, String escaper, Character ... escapees) {
        return LangUtilities.unescape(string, escaper, (Object[])escapees);
    }

    public static String unescape(String string, String ... escapees) {
        return LangUtilities.unescape(string, DEFAULT_ESCAPER, (Object[])escapees);
    }

    public static String unescape(String string, Character ... escapees) {
        return LangUtilities.unescape(string, DEFAULT_ESCAPER, (Object[])escapees);
    }

    public static int unsignedByteToInt(byte b) {
        return 0xFF & b;
    }

    public static boolean isNthBitSet(byte[] bytes, int n) {
        int byteN = n / 8;
        if (byteN < 0 || byteN >= bytes.length) {
            return false;
        }
        int mask = 1 << 7 - n % 8;
        int b = LangUtilities.unsignedByteToInt(bytes[byteN]);
        return (mask & b) != 0;
    }

    private static long lowZeroBitCount(long n, int maxBitCount) {
        long cnt = 0L;
        while ((n & 1L) == 0L && cnt < (long)maxBitCount) {
            ++cnt;
            n >>= 1;
        }
        return cnt;
    }

    public static long lowZeroBitCount(long n) {
        return LangUtilities.lowZeroBitCount(n, 64);
    }

    public static int lowZeroBitCount(int n) {
        return (int)LangUtilities.lowZeroBitCount(n, 32);
    }

    public static byte xorBytes(byte a, byte b) {
        return (byte)(0xFF & (a ^ b));
    }

    public static <T> boolean equals(T object1, T object2) {
        return Objects.deepEquals(object1, object2);
    }

    public static byte[] reverseBytes(byte[] old) {
        byte[] result = new byte[old.length];
        for (int i = 0; i < old.length; ++i) {
            result[i] = old[old.length - i - 1];
        }
        return result;
    }

    public static byte[] concat(byte[] ... data) {
        byte[] result = new byte[]{};
        for (byte[] datum : data) {
            result = Arrays.copyOf(result, result.length + datum.length);
            System.arraycopy(datum, 0, result, result.length - datum.length, datum.length);
        }
        return result;
    }

    public static String formatSentence(String sentence) {
        boolean sentenceNeedsPeriod;
        int i;
        if (sentence.length() == 0) {
            return sentence;
        }
        StringBuilder sentenceBuilder = new StringBuilder();
        for (i = 0; i < sentence.length(); ++i) {
            char c = sentence.charAt(i);
            if (Character.isLetter(c)) {
                sentenceBuilder.append(Character.toUpperCase(sentence.charAt(i)));
                break;
            }
            if (Character.isDigit(c)) {
                sentenceBuilder.append(c);
                break;
            }
            sentenceBuilder.append(c);
        }
        sentenceBuilder.append(sentence.substring(i + 1));
        char lastCharacterOfSentence = sentence.charAt(sentence.length() - 1);
        boolean bl = sentenceNeedsPeriod = lastCharacterOfSentence != '.' && lastCharacterOfSentence != '!' && lastCharacterOfSentence != '?';
        if (sentenceNeedsPeriod) {
            sentenceBuilder.append(".");
        }
        return sentenceBuilder.toString();
    }

    public static long myOwnProcessId() {
        try {
            RuntimeMXBean rmxb = ManagementFactory.getRuntimeMXBean();
            String jvmName = rmxb.getName();
            long pid = Long.valueOf(jvmName.split("@")[0]);
            return pid;
        }
        catch (Throwable e) {
            return -1L;
        }
    }

    public static void deprecated() {
        String method = ExceptionUtils.whereAmICalledFrom();
        throw new IllegalStateException("You are calling a method '" + method + "' that has been deprecated and provides no replacement. Please don't use this API.");
    }

    public static byte reverseBits(byte b) {
        int x = 0 | b << 8;
        return (byte)(Integer.reverse(x) >> 16 & 0xFFFF);
    }

    public static int findSubarray(byte[] haystack, byte[] needle) {
        if (haystack == null || needle == null) {
            return -1;
        }
        if (haystack.length == 0 || needle.length == 0) {
            return -1;
        }
        int foundIndex = -1;
        block0: for (int i = 0; i <= haystack.length - needle.length; ++i) {
            for (int j = 0; j < needle.length; ++j) {
                if (needle[j] != haystack[i + j]) continue block0;
            }
            foundIndex = i;
            break;
        }
        return foundIndex;
    }

    public static void sleepSafely(int timeout2) {
        try {
            Thread.sleep(timeout2);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }

    public static void joinSafely(Collection<Thread> threads) {
        for (Thread t : threads) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

