/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils;

import com.silabs.java.utils.api.IActionParserListener;
import com.silabs.java.utils.api.ICanceler;
import com.silabs.java.utils.api.ILineHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;

public class LineParser<T> {
    private final LineNumberReader is;
    private final ILineHandler<T> handler;
    private final IActionParserListener<T> internalListener;
    private final List<IActionParserListener<T>> listeners = new ArrayList<IActionParserListener<T>>();

    public LineParser(InputStream is, ILineHandler<T> handler) {
        this.internalListener = new InternalActionListener();
        this.is = new LineNumberReader(new InputStreamReader(is));
        this.handler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActionListener(IActionParserListener<T> listener) {
        List<IActionParserListener<T>> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActionListener(IActionParserListener<T> listener) {
        List<IActionParserListener<T>> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public void parse(T context) throws IOException {
        this.parse(context, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(T context, ICanceler canceler) throws IOException {
        block10: {
            block5: while (true) {
                while (true) {
                    if (canceler != null && canceler.isCanceled()) {
                        break block10;
                    }
                    String line = this.is.readLine();
                    if (line == null) {
                        break block10;
                    }
                    if (this.handler == null) continue;
                    try {
                        this.handler.handle(context, line, this.internalListener);
                        continue block5;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    break;
                }
            }
            finally {
                if (this.handler != null) {
                    this.handler.endOfInput(context, this.internalListener);
                }
            }
        }
    }

    private class InternalActionListener
    implements IActionParserListener<T> {
        private InternalActionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void parseAction(T context, String token, Object ... values2) {
            List list = LineParser.this.listeners;
            synchronized (list) {
                for (IActionParserListener l : LineParser.this.listeners) {
                    l.parseAction(context, token, values2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void endOfInput(T context) {
            List list = LineParser.this.listeners;
            synchronized (list) {
                for (IActionParserListener l : LineParser.this.listeners) {
                    l.endOfInput(context);
                }
            }
        }
    }
}

