/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils;

import com.silabs.java.utils.TextUtils;
import com.silabs.java.utils.annotation.ScriptReferenced;

@ScriptReferenced
public class Pair<T, U> {
    public T first;
    public U second;

    public Pair(T first, U second) {
        this.first = first;
        this.second = second;
    }

    public static <T, U> Pair<T, U> of(T first, U second) {
        return new Pair<T, U>(first, second);
    }

    public T first() {
        return this.first;
    }

    public U second() {
        return this.second;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.first == null ? 0 : this.first.hashCode());
        result = 31 * result + (this.second == null ? 0 : this.second.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Pair other = (Pair)obj;
        if (this.first == null ? other.first != null : !this.first.equals(other.first)) {
            return false;
        }
        return !(this.second == null ? other.second != null : !this.second.equals(other.second));
    }

    public String toString() {
        String firstStr = this.first instanceof Object[] ? "{" + TextUtils.catenateStrings((Object[])this.first, ", ") + "}" : String.valueOf(this.first);
        String secondStr = this.second instanceof Object[] ? "{" + TextUtils.catenateStrings((Object[])this.second, ", ") + "}" : String.valueOf(this.second);
        return "(" + firstStr + ", " + secondStr + ")";
    }
}

