/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils;

import java.util.Timer;
import java.util.TimerTask;

public class PooledRunnableScheduler {
    private Timer timer;
    private Runnable runnable;
    private long intervalMs;
    private volatile boolean eventOccurred;

    public PooledRunnableScheduler(String name, long intervalMs, Runnable runnable2) {
        this.intervalMs = intervalMs;
        this.runnable = runnable2;
        this.timer = new Timer(name, true);
    }

    public PooledRunnableScheduler start(long delayMs) {
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (PooledRunnableScheduler.this.eventOccurred) {
                    PooledRunnableScheduler.this.runnable.run();
                }
            }
        }, delayMs, this.intervalMs);
        return this;
    }

    public void cancel() {
        this.eventOccurred = false;
    }

    public void eventOccurred() {
        this.eventOccurred = true;
    }

    public void dispose() {
        this.eventOccurred = false;
        this.timer.cancel();
    }
}

